/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.ProgressMeter;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.RecentItemTextField;
import org.freehep.application.StatusBar;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.web.ClasspathStreamHandler;
import org.freehep.jas.plugin.web.DefaultHTMLComponentFactory;
import org.freehep.jas.plugin.web.HTMLPage;
import org.freehep.jas.plugin.web.WebPreferences;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.jas.services.WebBrowser;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.images.ImageHandler;
import org.freehep.util.template.PropertiesValueProvider;
import org.freehep.util.template.TemplateEngine;
import org.freehep.util.template.ValueProvider;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class SimpleWebBrowser
extends Plugin
implements FileHandler,
PreferencesTopic,
WebBrowser {
    private static final String[] path = new String[]{"Web Browser"};
    private Icon icon = ImageHandler.getIcon((String)"images/Web.gif", SimpleWebBrowser.class);
    private Properties props;
    private TemplateEngine engine;
    private WebBrowserCommands commands;

    public void setAntiAlias(boolean antiAlias) {
        Component c;
        PropertyUtilities.setBoolean(this.props, "antiAlias", antiAlias);
        PageContext pg = this.getApplication().getPageManager().getSelectedPage();
        if (pg != null && (c = pg.getPage()) instanceof HTMLPage) {
            c.repaint();
        }
    }

    public boolean isAntiAlias() {
        return PropertyUtilities.getBoolean(this.props, "antiAlias", false);
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(new String[]{"html", "htm"}, "HTML File");
    }

    public void setHomePage(URL homePage) {
        if (homePage == null) {
            this.props.remove("startPage");
        } else {
            this.props.setProperty("startPage", homePage.toExternalForm());
        }
    }

    public URL getHomePage() {
        String url = this.props.getProperty("startPage", "classpath:/org/freehep/jas/web/welcome.html");
        if (url == null) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException x) {
            return null;
        }
    }

    public ProgressMeter getProgressMeter() {
        StatusBar bar = this.getApplication().getStatusBar();
        ProgressMeter meter = new ProgressMeter();
        bar.add(meter);
        bar.revalidate();
        return meter;
    }

    public void setShowAtStart(boolean showAtStart) {
        PropertyUtilities.setBoolean(this.props, "showWelcomePageAtStart", showAtStart);
        this.commands.setChanged();
    }

    public boolean isShowAtStart() {
        return PropertyUtilities.getBoolean(this.props, "showWelcomePageAtStart", true);
    }

    @Override
    public boolean accept(File file) throws IOException {
        return file.getName().endsWith(".html") || file.getName().endsWith(".htm");
    }

    @Override
    public boolean apply(JComponent panel) {
        return ((WebPreferences)panel).apply();
    }

    @Override
    public JComponent component() {
        return new WebPreferences(this);
    }

    public void freeProgressMeter(ProgressMeter meter) {
        StatusBar bar = this.getApplication().getStatusBar();
        bar.remove(meter);
        bar.revalidate();
    }

    @Override
    protected void postInit() {
        Studio app = this.getApplication();
        app.getLookup().add((Object)new ClasspathStreamHandler(app.getExtensionLoader()), "classpath");
    }

    @Override
    protected void applicationVisible() {
        Studio app = this.getApplication();
        if (this.isShowAtStart()) {
            URL home = this.getHomePage();
            String startPage = app.getCommandLine().getOption("startPage");
            if (startPage != null) {
                try {
                    home = new URL(startPage);
                }
                catch (MalformedURLException x) {
                    x.printStackTrace();
                }
            }
            if (home != null) {
                this.showURL(home);
            }
        }
    }

    @Override
    public void openFile(File file) throws IOException {
        URL url = file.toURL();
        HTMLPage page = new HTMLPage(url, this.getApplication(), this);
        this.getApplication().getPageManager().openPage(page, null, this.icon, "Browser");
    }

    @Override
    public String[] path() {
        return path;
    }

    @Override
    public void showURL(URL url, boolean external) {
        if (external) {
            try {
                Desktop.getDesktop().browse(url.toURI());
            }
            catch (Exception x) {
                this.getApplication().error("Error launching external browser.", x);
            }
        } else {
            this.showURL(url);
        }
    }

    @Override
    public void showURL(URL url) {
        Component c;
        Studio app = this.getApplication();
        PageContext context2 = app.getPageManager().getSelectedPage();
        if (context2 != null && (c = context2.getPage()) instanceof HTMLPage) {
            ((HTMLPage)c).showURL(url);
            return;
        }
        List l = app.getPageManager().pages();
        for (PageContext context2 : l) {
            Component c2 = context2.getPage();
            if (!(c2 instanceof HTMLPage)) continue;
            context2.requestShow();
            ((HTMLPage)c2).showURL(url);
            return;
        }
        HTMLPage page = new HTMLPage(url, this.getApplication(), this);
        app.getPageManager().openPage(page, null, this.icon, "Browser");
    }

    @Override
    protected void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        app.getLookup().add((Object)this, "Web Browser");
        this.props = app.getUserProperties();
        DefaultHTMLComponentFactory factory = new DefaultHTMLComponentFactory();
        factory.init(app);
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("SimpleWebBrowser.menus");
        builder.build(xml);
        this.commands = new WebBrowserCommands();
        app.getCommandTargetManager().add((CommandGroup)this.commands);
        app.addToolBar(builder.getToolBar("webToolBar"), "Web Toolbar");
        this.engine = new TemplateEngine();
        this.engine.addValueProvider((ValueProvider)new PropertiesValueProvider(app.getUserProperties()));
        this.engine.addValueProvider((ValueProvider)new TemplateLookup(app));
    }

    TemplateEngine getTemplateEngine() {
        return this.engine;
    }

    private class TemplateLookup
    implements ValueProvider {
        private Studio app;

        TemplateLookup(Studio app) {
            this.app = app;
        }

        public String getValue(String name) {
            return null;
        }

        public List getValues(String name) {
            Lookup.Template query;
            FreeHEPLookup lookup = this.app.getLookup();
            Lookup.Result result = lookup.lookup(query = new Lookup.Template(ValueProvider.class, name, null));
            if (result == null) {
                return Collections.EMPTY_LIST;
            }
            return new ArrayList(result.allInstances());
        }
    }

    public class WebBrowserCommands
    extends CommandProcessor {
        public void enableHome(CommandState state) {
            state.setEnabled(SimpleWebBrowser.this.getHomePage() != null);
        }

        public void enableShowWelcomeAtStart(BooleanCommandState state) {
            state.setSelected(SimpleWebBrowser.this.isShowAtStart());
            state.setEnabled(true);
        }

        public void onHome() {
            SimpleWebBrowser.this.showURL(SimpleWebBrowser.this.getHomePage());
        }

        public void onShowWelcomeAtStart(boolean start) {
            SimpleWebBrowser.this.setShowAtStart(start);
            this.setChanged();
        }

        public void onWebPage() throws MalformedURLException {
            String input = RecentItemTextField.showInputDialog(SimpleWebBrowser.this.getApplication(), "URL", "webPage");
            if (input != null) {
                URL url = new URL(input);
                SimpleWebBrowser.this.showURL(url);
            }
        }
    }
}

