/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.console;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.freehep.jas.plugin.console.ConsoleInputStream;
import org.freehep.jas.plugin.console.ConsoleOutputStream;

public class Console
extends JTextPane {
    private static final String defaultPrompt = "> ";
    private String currentPrompt;
    private List<String> history = new LinkedList<String>();
    private List<ListEntry> outputList = new ArrayList<ListEntry>();
    private ListEntry lastItemInOutputList;
    private final Object inputStreamLock = new Object();
    private PrintStream logStream;
    private ConsoleInputStream theInputStream;
    private final List<ConsoleOutputStream> outputStreams = new ArrayList<ConsoleOutputStream>();
    private SimpleAttributeSet defStyle;
    private SimpleAttributeSet promptStyle;
    private StringBuffer pasteAhead = new StringBuffer();
    private StringBuffer typeAhead = new StringBuffer();
    private List<String> queue = new LinkedList<String>();
    private MyTimer timer;
    private boolean log;
    private boolean waitingForInput = false;
    private int historyPos = -1;
    private int maxHistory = 100;
    private int maxScrollback = 1000;
    private int start;
    private int startLastLine;
    private static final Logger logger = Logger.getLogger(Console.class.getName());
    private AutoShow autoShow = AutoShow.DEFAULT;

    public Console() {
        this.setFont(new Font("Courier", 0, 14));
        this.setPreferredSize(new Dimension(300, 200));
        this.addKeyListener(new CKeyListener());
        this.timer = new MyTimer(new CTimerListener());
        this.setEditable(false);
        this.setEditorKit(new NowrapEditorKit());
        this.defStyle = new SimpleAttributeSet(){

            @Override
            public Object getAttribute(Object key) {
                if (key.equals(StyleConstants.Foreground)) {
                    return Console.this.getForeground();
                }
                return super.getAttribute(key);
            }
        };
        this.promptStyle = new SimpleAttributeSet();
        this.promptStyle.addAttribute(StyleConstants.Foreground, new Color(0, 153, 51));
    }

    public ConsoleInputStream getInputStream() {
        return this.getInputStream(defaultPrompt);
    }

    public ConsoleInputStream getInputStream(String initialPrompt) {
        if (this.theInputStream == null) {
            this.theInputStream = new CInputStream(initialPrompt);
        }
        return this.theInputStream;
    }

    public synchronized void setLogStream(OutputStream out) {
        boolean bl = this.log = out != null;
        if (this.logStream != null) {
            this.logStream.flush();
        }
        this.logStream = this.log ? new PrintStream(out) : null;
    }

    public OutputStream getLogStream() {
        return this.logStream;
    }

    public synchronized void setLoggingEnabled(boolean log) {
        this.log = log && this.logStream != null;
    }

    public boolean isLoggingEnabled() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleOutputStream getOutputStream(AttributeSet set, boolean autoShow) {
        COutputStream out = new COutputStream(this, set, autoShow);
        List<ConsoleOutputStream> list = this.outputStreams;
        synchronized (list) {
            this.outputStreams.add(out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutputStream(ConsoleOutputStream out) {
        List<ConsoleOutputStream> list = this.outputStreams;
        synchronized (list) {
            this.outputStreams.remove(out);
        }
    }

    public ConsoleOutputStream getOutputStream(AttributeSet set) {
        return this.getOutputStream(set, false);
    }

    public void addInterruptListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<ConsoleOutputStream> temp;
        this.setLogStream(null);
        if (this.theInputStream != null) {
            try {
                Object object = this.inputStreamLock;
                synchronized (object) {
                    this.theInputStream.close();
                    this.theInputStream = null;
                    this.inputStreamLock.notify();
                }
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        List<ConsoleOutputStream> list = this.outputStreams;
        synchronized (list) {
            temp = new ArrayList<ConsoleOutputStream>(this.outputStreams);
        }
        for (ConsoleOutputStream out : temp) {
            try {
                out.close();
            }
            catch (IOException x) {}
        }
    }

    public void insertTextAsIfTypedByUser(String text) {
        if (!this.isEditable()) {
            throw new RuntimeException("Cannot send text to non-editable console");
        }
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        if (this.waitingForInput) {
            int pos = text.indexOf(10);
            String firstLine = text.substring(0, pos);
            String originalText = this.lastLine();
            Document doc = this.getDocument();
            this.remove(this.start, doc.getLength() - this.start);
            this.insertString(this.start, firstLine + "\n", null);
            this.sendToInputStream(firstLine);
            this.pasteAhead.append(text.substring(pos + 1));
            this.pasteAhead.append(originalText);
        } else {
            this.pasteAhead.append(text);
            if (!text.endsWith("\n")) {
                this.pasteAhead.append('\n');
            }
        }
    }

    @Override
    public void paste() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
        } else {
            try {
                Transferable t = this.getToolkit().getSystemClipboard().getContents(this);
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                text = this.removeIllegalCharacters(text);
                if (this.waitingForInput) {
                    int pos = text.indexOf(10);
                    boolean containsEOL = pos >= 0;
                    String firstLine = containsEOL ? text.substring(0, pos) : text;
                    int sStart = Math.max(this.start, this.getSelectionStart());
                    int sEnd = Math.max(this.start, this.getSelectionEnd());
                    if (sEnd - sStart > 0) {
                        this.remove(sStart, sEnd - sStart);
                    }
                    int cPos = this.getCaretPosition();
                    if (containsEOL) {
                        this.insertString(cPos, firstLine + "\n", null);
                        this.sendToInputStream(firstLine);
                        this.pasteAhead.append(text.substring(pos + 1));
                    } else {
                        this.insertString(cPos, firstLine, null);
                    }
                } else {
                    this.pasteAhead.append(text);
                }
            }
            catch (UnsupportedFlavorException ex) {
                logger.log(Level.SEVERE, "Unsupported flavor during paste", ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error during paste", ex);
            }
        }
    }

    private String removeIllegalCharacters(String in) {
        StringBuffer out = null;
        int l = in.length();
        for (int i = 0; i < l; ++i) {
            char c = in.charAt(i);
            if (c < ' ' && c != '\n') {
                if (out != null) continue;
                out = new StringBuffer(in.substring(0, i));
                continue;
            }
            if (out == null) continue;
            out.append(c);
        }
        if (out == null) {
            return in;
        }
        return out.toString();
    }

    public void close() {
    }

    protected void autoShow() {
    }

    public void removeInterruptListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireInterruptAction() {
        int count = this.listenerList.getListenerCount(ActionListener.class);
        if (count > 0) {
            ActionEvent event = new ActionEvent(this, 1001, "Break");
            ActionListener[] listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
            int i = listeners.length;
            while (i-- > 0) {
                listeners[i].actionPerformed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Document d = this.getDocument();
        this.remove(0, d.getLength());
        if (this.waitingForInput) {
            Object object = this.inputStreamLock;
            synchronized (object) {
                this.inputStreamLock.notify();
            }
        }
    }

    private void setLastLine(String line) {
        int end = this.getDocument().getLength();
        if (end > this.start) {
            this.remove(this.start, end - this.start);
        }
        this.insertString(this.start, line, null);
    }

    private void consumeAndBeep(KeyEvent event) {
        event.consume();
        this.getToolkit().beep();
    }

    private void prepareToFlush() {
        if (this.waitingForInput) {
            this.typeAhead.append(this.lastLine());
            Document doc = this.getDocument();
            this.remove(this.startLastLine, doc.getLength() - this.startLastLine);
            this.writePrompt(this.theInputStream.getCurrentPrompt(), null);
        } else {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        List<ListEntry> previousOutputList = this.outputList;
        Console console = this;
        synchronized (console) {
            this.outputList = new ArrayList<ListEntry>();
            this.lastItemInOutputList = null;
        }
        Document doc = this.getDocument();
        final JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        boolean scrollBarWasAtEnd = viewport != null && viewport.getView() == this && viewport.getViewPosition().y + viewport.getExtentSize().height > viewport.getViewSize().height - 5;
        for (ListEntry entry : previousOutputList) {
            this.insertString(doc.getLength(), entry.string.toString(), entry.set);
        }
        if (scrollBarWasAtEnd) {
            Runnable runnable = new Runnable(){
                private int delay = 2;

                @Override
                public void run() {
                    if (this.delay-- > 0) {
                        SwingUtilities.invokeLater(this);
                    }
                    viewport.setViewPosition(new Point(viewport.getViewPosition().x, viewport.getViewSize().height - viewport.getExtentSize().height));
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private boolean inLastLine() {
        int caret = this.getCaretPosition();
        return caret >= this.start;
    }

    private String lastLine() {
        try {
            Document doc = this.getDocument();
            return doc.getText(this.start, doc.getLength() - this.start);
        }
        catch (BadLocationException ex) {
            this.logBadLocation(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToInputStream(String line) {
        if (this.logStream != null && this.log) {
            this.logStream.println(this.currentPrompt + line);
        }
        Object object = this.inputStreamLock;
        synchronized (object) {
            boolean wasEmpty = this.queue.isEmpty();
            this.queue.add(line + "\n");
            if (line.length() > 0) {
                this.history.add(line);
            }
            while (this.history.size() >= this.maxHistory) {
                this.history.remove(0);
            }
            this.historyPos = this.history.size();
            if (wasEmpty) {
                this.inputStreamLock.notify();
                this.waitingForInput = false;
            }
        }
    }

    @Override
    public MutableAttributeSet getInputAttributes() {
        return this.defStyle;
    }

    private void writeMessage(String line, AttributeSet style) {
        Document doc = this.getDocument();
        this.insertString(doc.getLength(), line, style);
        this.setCaretPosition(doc.getLength());
    }

    private void writeOutput(byte[] b, int off, int len, AttributeSet set) throws IOException {
        if (this.isLoggingEnabled()) {
            this.logStream.write(b, off, len);
        }
        this.writeOutput(new String(b, off, len), set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(String s, AttributeSet set) throws IOException {
        Console console = this;
        synchronized (console) {
            boolean wasEmpty = this.outputList.isEmpty();
            if (this.lastItemInOutputList != null && set == this.lastItemInOutputList.set) {
                this.lastItemInOutputList.string.append(s);
            } else {
                this.lastItemInOutputList = new ListEntry(s, set);
                this.outputList.add(this.lastItemInOutputList);
            }
            if (wasEmpty) {
                this.timer.startLater();
            }
        }
    }

    private void writePrompt(String prompt, String initialEntry) {
        this.flush();
        this.startLastLine = this.getDocument().getLength();
        try {
            Rectangle r = this.modelToView(this.startLastLine);
            Insets insets = this.getInsets();
            if (r != null && r.x > insets.left) {
                this.writeMessage("\n", this.defStyle);
                this.startLastLine = this.getDocument().getLength();
            }
        }
        catch (BadLocationException x) {
            // empty catch block
        }
        this.currentPrompt = prompt;
        if (prompt != null) {
            this.writeMessage(prompt, this.promptStyle);
        }
        this.start = this.getDocument().getLength();
        if (this.pasteAhead.length() > 0) {
            boolean hasEOL;
            int pos = this.pasteAhead.indexOf("\n");
            boolean bl = hasEOL = pos >= 0;
            if (hasEOL) {
                String ta = this.pasteAhead.substring(0, pos);
                this.writeMessage(ta + "\n", null);
                this.pasteAhead.delete(0, pos + 1);
                String text = this.lastLine();
                this.setCaretPosition(this.getDocument().getLength());
                text = text.substring(0, text.length() - 1);
                this.sendToInputStream(text);
                return;
            }
            this.writeMessage(this.pasteAhead.toString(), null);
            this.pasteAhead.setLength(0);
            if (this.typeAhead.length() > 0) {
                this.writeMessage(this.typeAhead.toString(), null);
                this.typeAhead.setLength(0);
            }
        } else {
            if (initialEntry != null) {
                this.writeMessage(initialEntry, null);
            }
            if (this.typeAhead.length() > 0) {
                this.writeMessage(this.typeAhead.toString(), null);
                this.typeAhead.setLength(0);
            }
        }
        this.setEditable(true);
        if (!this.getCaret().isVisible() && this.hasFocus()) {
            this.getCaret().setVisible(true);
        }
        this.waitingForInput = true;
    }

    public Color getPromptColor() {
        return (Color)this.promptStyle.getAttribute(StyleConstants.Foreground);
    }

    public void setPromptColor(Color promptColor) {
        this.promptStyle.addAttribute(StyleConstants.Foreground, promptColor);
    }

    public int getMaxScrollback() {
        return this.maxScrollback;
    }

    public void setMaxScrollback(int maxLines) {
        this.maxScrollback = maxLines;
        this.insertString(this.getDocument().getLength(), "", null);
    }

    public AutoShow getAutoShow() {
        return this.autoShow;
    }

    public void setAutoShow(AutoShow autoShow) {
        this.autoShow = autoShow;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertString(int position, String line, AttributeSet style) {
        Document doc = this.getDocument();
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        try {
            caret.setUpdatePolicy(1);
            doc.insertString(position, line, style == null ? this.defStyle : style);
            View baseView = this.getUI().getRootView(this);
            View root = baseView.getView(0);
            if (root.getViewCount() > this.maxScrollback) {
                View lineView = root.getView(root.getViewCount() - this.maxScrollback);
                int offset = lineView.getStartOffset();
                doc.remove(0, offset);
                if (this.getSelectionStart() > 0) {
                    this.setSelectionStart(Math.max(0, this.getSelectionStart() - offset));
                }
                if (this.getSelectionEnd() > 0) {
                    this.setSelectionEnd(Math.max(0, this.getSelectionEnd() - offset));
                }
            }
        }
        catch (BadLocationException ex) {
            this.logBadLocation(ex);
        }
        finally {
            caret.setUpdatePolicy(0);
        }
    }

    private void remove(int start, int end) {
        try {
            this.getDocument().remove(start, end);
        }
        catch (BadLocationException ex) {
            this.logBadLocation(ex);
        }
    }

    private void logBadLocation(BadLocationException ex) {
        Logger.getLogger(Console.class.getName()).log(Level.INFO, "Unexpected location exception", ex);
    }

    private static class NoWrapViewFactory
    implements ViewFactory {
        private final ViewFactory delegate;

        NoWrapViewFactory(ViewFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null && kind.equals("paragraph")) {
                return new NoWrapParagraphView(elem);
            }
            return this.delegate.create(elem);
        }
    }

    private static class NowrapEditorKit
    extends StyledEditorKit {
        private ViewFactory defaultFactory;

        private NowrapEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            if (this.defaultFactory == null) {
                this.defaultFactory = new NoWrapViewFactory(super.getViewFactory());
            }
            return this.defaultFactory;
        }
    }

    private static class NoWrapParagraphView
    extends ParagraphView {
        public NoWrapParagraphView(Element elem) {
            super(elem);
        }

        @Override
        public void layout(int width, int height) {
            super.layout(Short.MAX_VALUE, height);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return super.getPreferredSpan(axis);
        }
    }

    private static class MyTimer
    extends Timer
    implements Runnable {
        MyTimer(ActionListener l) {
            super(10, l);
            this.setRepeats(false);
        }

        @Override
        public void run() {
            this.start();
        }

        void startLater() {
            SwingUtilities.invokeLater(this);
        }
    }

    private static class ListEntry {
        AttributeSet set;
        StringBuffer string;

        ListEntry(String string, AttributeSet set) {
            this.string = new StringBuffer(string);
            this.set = set;
        }
    }

    private static class COutputStream
    extends ConsoleOutputStream {
        private Console console;

        COutputStream(Console console, AttributeSet set, boolean autoShow) {
            super(set, autoShow);
            this.console = console;
        }

        @Override
        public void write(byte[] b, int off, int len, AttributeSet set) throws IOException {
            Console local = this.console;
            if (local == null) {
                throw new IOException("File closed");
            }
            local.writeOutput(b, off, len, set);
            if (local.getAutoShow() == AutoShow.ALWAYS || this.isAutoShow() && local.getAutoShow() == AutoShow.DEFAULT) {
                local.autoShow();
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            Console local = this.console;
            if (local != null) {
                local.closeOutputStream(this);
            }
            this.console = null;
        }
    }

    private class CKeyListener
    extends KeyAdapter {
        private CKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int kc = keyEvent.getKeyCode();
            if (kc == 67 && (keyEvent.getModifiers() & 2) != 0) {
                Console.this.fireInterruptAction();
            } else if (kc == 10) {
                if (!Console.this.waitingForInput) {
                    keyEvent.consume();
                } else {
                    Console.this.setCaretPosition(Console.this.getDocument().getLength());
                }
            } else if (!Console.this.inLastLine()) {
                keyEvent.consume();
            } else if (keyEvent.getKeyChar() == '\b' && Console.this.getCaretPosition() == Console.this.start) {
                Console.this.consumeAndBeep(keyEvent);
            } else if (kc == 37 || kc == 226) {
                if (Console.this.getCaretPosition() == Console.this.start) {
                    Console.this.consumeAndBeep(keyEvent);
                }
            } else if (kc == 36) {
                if (Console.this.getCaretPosition() > Console.this.start) {
                    Console.this.setCaretPosition(Console.this.start);
                    keyEvent.consume();
                } else {
                    Console.this.consumeAndBeep(keyEvent);
                }
            } else if (kc == 38 || kc == 224) {
                if (Console.this.historyPos <= 0) {
                    Console.this.consumeAndBeep(keyEvent);
                } else {
                    String line = (String)Console.this.history.get(--Console.this.historyPos);
                    Console.this.setLastLine(line);
                    Console.this.setCaretPosition(Console.this.getDocument().getLength());
                    keyEvent.consume();
                }
            } else if (kc == 40 || kc == 225) {
                if (Console.this.historyPos >= Console.this.history.size() - 1) {
                    Console.this.consumeAndBeep(keyEvent);
                } else {
                    String line = (String)Console.this.history.get(++Console.this.historyPos);
                    Console.this.setLastLine(line);
                    Console.this.setCaretPosition(Console.this.getDocument().getLength());
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (Console.this.waitingForInput) {
                if (!Console.this.inLastLine()) {
                    Console.this.setCaretPosition(Console.this.getDocument().getLength());
                } else {
                    Caret caret = Console.this.getCaret();
                    if (caret.getMark() < Console.this.start) {
                        int pos = caret.getDot();
                        caret.setDot(Console.this.start);
                        caret.moveDot(pos);
                    }
                }
                if (keyEvent.getKeyChar() == '\n') {
                    Console.this.theInputStream.clearOneTimePrompt();
                    String text = Console.this.lastLine();
                    Console.this.setCaretPosition(Console.this.getDocument().getLength());
                    text = text.substring(0, text.length() - 1);
                    Console.this.sendToInputStream(text);
                }
            } else {
                if (keyEvent.getKeyChar() == '\b') {
                    int l = Console.this.typeAhead.length();
                    if (l > 0) {
                        Console.this.typeAhead.deleteCharAt(l - 1);
                    }
                } else if (keyEvent.getKeyChar() == '\n') {
                    Console.this.pasteAhead.append(Console.this.typeAhead);
                    Console.this.pasteAhead.append('\n');
                    Console.this.typeAhead.setLength(0);
                } else if ((keyEvent.getModifiers() & 2) == 0) {
                    Console.this.typeAhead.append(keyEvent.getKeyChar());
                }
                keyEvent.consume();
            }
        }
    }

    private class CTimerListener
    implements ActionListener {
        private CTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Console.this.outputList.isEmpty()) {
                Console.this.prepareToFlush();
            }
        }
    }

    private class CInputStream
    extends ConsoleInputStream
    implements Runnable {
        private int pos;
        private byte[] buffer;

        CInputStream(String prompt) {
            this.setPrompt(prompt);
        }

        @Override
        public int read() throws IOException {
            if (!(this.buffer != null && this.pos < this.buffer.length || this.fillBuffer())) {
                return -1;
            }
            return this.buffer[this.pos++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!(this.buffer != null && this.pos < this.buffer.length || this.fillBuffer())) {
                return -1;
            }
            int l = Math.min(len, this.buffer.length - this.pos);
            System.arraycopy(this.buffer, this.pos, b, off, l);
            this.pos += l;
            return l;
        }

        @Override
        public void run() {
            Console.this.writePrompt(this.getCurrentPrompt(), this.getInitialEntry());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fillBuffer() throws IOException {
            Object object = Console.this.inputStreamLock;
            synchronized (object) {
                while (Console.this.queue.isEmpty()) {
                    try {
                        if (Console.this.theInputStream == null) {
                            return false;
                        }
                        SwingUtilities.invokeLater(this);
                        Console.this.inputStreamLock.wait();
                        if (Console.this.theInputStream != null) continue;
                        return false;
                    }
                    catch (InterruptedException x) {
                        throw new InterruptedIOException();
                    }
                }
                String line = (String)Console.this.queue.remove(0);
                this.buffer = line.getBytes();
                this.pos = 0;
            }
            return true;
        }
    }

    public static enum AutoShow {
        DEFAULT,
        NEVER,
        ALWAYS;

    }
}

