/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessagingLayer;

class MessagingAccessManager {
    private static final List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<AgentMessagingLayer>();

    MessagingAccessManager() {
    }

    static void addMessagingAccess(AgentMessagingLayer msgFact) {
        msgAccesses.add(msgFact);
    }

    static void removeMessagingAccess(AgentMessagingLayer msgFact) {
        msgAccesses.remove(msgFact);
    }

    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;
    }

    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess " + msgAccess.getAgentName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer " + layer);
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer " + messagingLayer);
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents " + localAgents.size());
        for (String agent : localAgents) {
            System.out.println("\t" + agent);
        }
    }
}

