/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;

public class MessagingAccessLayer {
    private final String name;
    private final List<BusAccess> busAccesses = new ArrayList<BusAccess>();

    public MessagingAccessLayer(String name, Bus ... buses) {
        this.name = name;
        if (buses == null) {
            buses = Bus.values();
        }
    }

    public String getName() {
        return this.name;
    }

    public List<BusAccess> getBusAccesses() {
        return this.busAccesses;
    }

    public void addBusAccess(BusAccess busAccess) {
        this.busAccesses.add(busAccess);
    }

    public static abstract class BusAccess<T extends BusMessage> {
        private Bus<T> bus;

        public BusAccess(Bus bus) {
            this.bus = bus;
        }

        public Bus<T> getBus() {
            return this.bus;
        }

        public abstract void processBusMessage(T var1);
    }

    public static abstract class StatusBusAccess
    extends BusAccess<StatusMessage> {
        public StatusBusAccess(Bus<StatusMessage> bus) {
            super(bus);
        }

        public abstract void processDisconnectionSuspicion(String var1, String var2);

        public abstract void processAnormalEvent(Exception var1);
    }
}

