/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.io.Serializable;
import java.util.logging.Level;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.StatusForEnd;
import org.lsst.ccs.bus.messages.StatusForStart;
import org.lsst.ccs.config.BootCommand;
import org.lsst.ccs.config.BootStatus;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.FIleBasedDAO;
import org.lsst.ccs.config.MachineConfiguration;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.remote.ConfigurationServerModule;
import org.lsst.ccs.config.remote.ConfigurationServiceImpl;
import org.lsst.ccs.framework.BasicModularSubSystem;
import org.lsst.ccs.messaging.StatusMessageListener;

public class ConfigurationServerSystem
extends BasicModularSubSystem {
    ConfigurationServiceImpl service;
    ConfigurationFacade facade;
    boolean forTestsOnly;
    private final StatusMessageListener bootStatusListener = s -> {
        String initiatorName = s.getOriginAgentInfo().getName();
        try {
            if (s instanceof BootStatus) {
                BootStatus bootStatus = (BootStatus)s;
                String requestedSubsystem = bootStatus.getRequestedSubsystem();
                String requestedConfiguration = bootStatus.getRequestedConfiguration();
                String requestedTag = bootStatus.getRequestedTag();
                String origin = bootStatus.getOriginAgentInfo().getName();
                boolean forTestContext = bootStatus.isInTestContext();
                if (!(this.forTestsOnly ^ forTestContext)) {
                    Serializable startupObject = null;
                    BootCommand cmd = null;
                    if (requestedSubsystem == null || "".equals(requestedSubsystem)) {
                        MachineConfiguration machineConfiguration = this.facade.getMachineConfiguration(origin);
                        requestedSubsystem = machineConfiguration.getSubsystemName();
                        requestedConfiguration = machineConfiguration.getConfigName();
                        requestedTag = machineConfiguration.getTag();
                    }
                    if ((cmd = new BootCommand(origin, requestedSubsystem, requestedConfiguration, requestedTag, startupObject = requestedConfiguration != null && !"".equals(requestedConfiguration) ? this.facade.getActiveConfigProfile(requestedSubsystem, requestedConfiguration, requestedTag) : this.facade.getActiveSubsystemDescription(requestedSubsystem, requestedTag))) == null) {
                        PackCst.CURLOG.log(Level.WARNING, "no descriptions for ", (Object)s, new String[0]);
                    }
                }
            } else if (s instanceof StatusForStart) {
                StatusForStart startStatus = (StatusForStart)s;
                if (startStatus.getOriginAgentInfo().getName().equals(this.getName())) {
                    return;
                }
                boolean forTestContext = startStatus.isInTestContext();
                if (!(this.forTestsOnly ^ forTestContext)) {
                    this.facade.registerRun(initiatorName, startStatus.getConfigurationName(), startStatus.getTag(), s.getTimeStamp());
                }
            } else if (s instanceof StatusForEnd) {
                StatusForEnd endStatus = (StatusForEnd)s;
                if (endStatus.getOriginAgentInfo().getName().equals(this.getName())) {
                    return;
                }
                boolean forTestContext = endStatus.isInTestContext();
                if (!(this.forTestsOnly ^ forTestContext)) {
                    this.facade.endRun(initiatorName, endStatus.getConfigurationName(), endStatus.getTag(), endStatus.getTimeStamp());
                }
            }
        }
        catch (Exception exc) {
            PackCst.CURLOG.log(Level.SEVERE, "on status message " + s, (Throwable)exc, new String[0]);
            System.err.println("ERROR :" + exc);
        }
    };

    public ConfigurationServerSystem(ConfigurationFacade facade) {
        super("configServer");
        this.facade = facade;
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false");
        this.forTestsOnly = "true".equals(testContext.toLowerCase());
        this.service = new ConfigurationServiceImpl(facade);
        this.addModule(new ConfigurationServerModule(this.service));
        this.getMessagingAccess().addStatusMessageListener(this.bootStatusListener);
    }

    public static void main(String[] args) throws Exception {
        ConfigurationFacade facade;
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false");
        if ("true".equals(testContext.toLowerCase())) {
            facade = new ConfigurationFacade(new FIleBasedDAO());
        } else {
            String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
            DBInterface dao = (DBInterface)Class.forName(clazzName).newInstance();
            facade = new ConfigurationFacade(dao);
        }
        ConfigurationServerSystem system = new ConfigurationServerSystem(facade);
        system.start();
        system.stayAlive();
    }
}

