/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.PlotterFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.plugin.jas3.trending.DataChannelHandler;
import org.lsst.ccs.plugin.jas3.trending.Plot;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindow;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindowComboBox;

public class PlotMaker {
    private final Studio app;
    private final TimeWindowComboBox timeRangeSelector;
    private final PlotterFactory plotterStyleFactory = new PlotterFactory();
    private PlotFactory plotFactory;

    public PlotMaker(Studio application, TimeWindowComboBox timeWindowSelector) {
        this.app = application;
        this.timeRangeSelector = timeWindowSelector;
    }

    public void plot(DataChannelHandler channel, TimeWindow timeWindow, boolean useExistingPlot, boolean newPage, boolean newPlot, boolean overlay) {
        Plot dps;
        if (channel == null) {
            return;
        }
        if (this.plotFactory == null) {
            this.plotFactory = (PlotFactory)this.app.getLookup().lookup(PlotFactory.class);
            if (this.plotFactory == null) {
                this.app.error("No plot factory available");
            }
        }
        if (timeWindow == null && (timeWindow = this.timeRangeSelector.getSelectedTimeWindow()) == null) {
            return;
        }
        PlotRegion region = null;
        PlotPage page = null;
        Plot plotData = channel.makePlot(timeWindow);
        if (useExistingPlot && (dps = channel.findPlot(timeWindow)) != null) {
            page = dps.getPage();
            region = dps.getRegion();
        }
        if (page == null) {
            if (!newPage) {
                page = this.plotFactory.currentPage();
            }
            if (page == null) {
                page = this.plotFactory.createPage(channel.getPath());
                if (page == null) {
                    this.app.error("Unable to create a plot page");
                    return;
                }
                page.createRegions(1, 1);
                region = page.currentRegion();
            }
        }
        if (region == null) {
            if (newPlot) {
                int n = page.numberOfRegions();
                int i = 0;
                while (i < n) {
                    PlotRegion r = page.region(i);
                    if (r.currentPlot() == null) {
                        region = r;
                        break;
                    }
                    ++i;
                }
            } else {
                region = page.currentRegion();
            }
            if (region == null) {
                region = page.addRegion();
            }
        }
        plotData.setPage(page);
        plotData.setRegion(region);
        page.setCurrentRegion(region);
        page.showPage();
        this.plotData(Collections.singletonList(plotData), page, region, overlay);
    }

    public void refresh(DataChannelHandler channel, TimeWindow timeWindow) {
        for (PlotRegion region : this.getRegions(channel)) {
            this.refresh(region, timeWindow);
        }
    }

    public void refresh(PlotPage page, TimeWindow timeWindow) {
        int n = page.numberOfRegions();
        int i = 0;
        while (i < n) {
            this.refresh(page.region(i), timeWindow);
            ++i;
        }
    }

    public void refresh(PlotRegion region, TimeWindow timeWindow) {
        try {
            if (((JComponent)region).getTopLevelAncestor() == null) {
                return;
            }
        }
        catch (ClassCastException classCastException) {}
        PlotPage page = null;
        Plotter plotter = region.currentPlot();
        if (plotter == null) {
            return;
        }
        ArrayList<Object> data = new ArrayList<Object>(plotter.getData());
        ListIterator<Plot> it = data.listIterator();
        while (it.hasNext()) {
            Object plottedObject = it.next();
            try {
                Plot plot = (Plot)plottedObject;
                TimeWindow tw = plot.getTimeWindow();
                if (timeWindow == null) {
                    if (tw.isFixed()) continue;
                    page = plot.getPage();
                    plot.commitRefresh();
                    continue;
                }
                page = plot.getPage();
                plot = plot.getChannel().makePlot(timeWindow);
                plot.setPage(page);
                plot.setRegion(region);
                it.set(plot);
            }
            catch (ClassCastException classCastException) {}
        }
        if (page != null) {
            this.plotData(data, page, region, false);
        }
    }

    private List<PlotRegion> getRegions(DataChannelHandler channel) {
        List<Plot> pdList = channel.getPlots();
        if (pdList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PlotRegion> out = new ArrayList<PlotRegion>(pdList.size());
        for (Plot pd : pdList) {
            out.add(pd.getRegion());
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plotData(List<Object> data, PlotPage page, PlotRegion region, boolean overlay) {
        boolean commonExtent;
        if (data.isEmpty()) {
            return;
        }
        Plotter plotter = region.currentPlot();
        if (plotter == null) {
            plotter = this.plotFactory.createPlotterFor(IBaseHistogram.class);
        } else if (!overlay) {
            plotter.clear();
        }
        IPlotterStyle style = this.plotterStyleFactory.createPlotterStyle();
        IAxisStyle xAxisStyle = style.xAxisStyle();
        xAxisStyle.setParameter("type", "date");
        boolean bl = commonExtent = data.size() > 1 && !overlay;
        if (commonExtent) {
            long tLow = Long.MAX_VALUE;
            long tHigh = 0L;
            for (Object datum : data) {
                try {
                    Plot pd;
                    Plot plot = pd = (Plot)datum;
                    synchronized (plot) {
                        tLow = Math.min(tLow, (long)pd.lowerExtent(0));
                        tHigh = Math.max(tHigh, (long)pd.upperExtent(0));
                    }
                    xAxisStyle.setParameter("lowerLimit", String.valueOf(tLow / 1000L));
                    xAxisStyle.setParameter("upperLimit", String.valueOf(tHigh / 1000L));
                }
                catch (ClassCastException classCastException) {}
            }
        }
        boolean needRefresh = false;
        int i = 0;
        while (i < data.size()) {
            Object datum;
            Object object = datum = data.get(i);
            synchronized (object) {
                try {
                    Plot pd = (Plot)datum;
                    needRefresh = needRefresh || !pd.getTimeWindow().isFixed();
                    pd.setPage(page);
                    pd.setRegion(region);
                    pd.getChannel().addPlotData(pd);
                    if (!commonExtent) {
                        xAxisStyle.setParameter("lowerLimit", String.valueOf(pd.lowerExtent(0) / 1000.0));
                        xAxisStyle.setParameter("upperLimit", String.valueOf(pd.upperExtent(0) / 1000.0));
                    }
                }
                catch (ClassCastException classCastException) {}
                plotter.plot(data.get(i), i == 0 && !overlay ? 0 : 1, (Object)style, "");
            }
            ++i;
        }
        region.showPlot(plotter);
    }
}

