/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.plots;

import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.plots.AidaPlots;

class PlotsListener
implements DataStatusListener {
    private final FreeHEPLookup lookup;
    private final Studio studio;
    private final PlotFactory plotFactory;
    private final FTreeProvider treeProvider;
    private final FTree tree;

    public PlotsListener(Studio studio) {
        this.studio = studio;
        this.lookup = studio.getLookup();
        this.plotFactory = (PlotFactory)this.lookup.lookup(PlotFactory.class);
        this.treeProvider = (FTreeProvider)this.lookup.lookup(FTreeProvider.class);
        this.tree = this.treeProvider.tree();
    }

    public void onDataArrival(String source, long timestamp, String key, Object value) {
        if (value instanceof AidaPlots && this.tree != null) {
            AidaPlots plots = (AidaPlots)value;
            for (String plot : plots.getPlots()) {
                final FTreePath path = new FTreePath(new String[]{source, plot});
                FTreeNode node = this.tree.findNode(path);
                try {
                    final IManagedObject obj = XMLUtils.createManagedObject((String)plots.getPlot(plot));
                    final boolean removeNode = node != null;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (removeNode) {
                                    PlotsListener.this.tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)PlotsListener.this.studio, path));
                                }
                                PlotsListener.this.tree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)PlotsListener.this.studio, path, (Object)obj));
                            }
                        });
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not create IManagedObject", ioe);
                }
            }
        }
    }
}

