package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryTreePanel extends JTree {

       private CommandListener commandListener;
       private TreeBranch<DictionaryContext> dictionaryTree;
       private CommandTreeRenderer renderer;


    public DictionaryTreePanel(CommandListener cmdListener) {
        super();
        this.setModel(new DefaultTreeModel(dictionaryTree));
       
        this.commandListener = cmdListener;
        getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        
        renderer = new CommandTreeRenderer(false);
        setCellRenderer(renderer);
    }

    public void updateRendererAndData(boolean isEM, String selectedSubsystem){
        renderer.setEM(isEM);
        new BuildDictionaryWorker(selectedSubsystem).execute();
    }
    
    public void updateRenderer(boolean isEM){
        renderer.setEM(isEM);
        this.revalidate();
        this.repaint();
    }
    
    private class BuildDictionaryWorker extends SwingWorker<TreeBranch<DictionaryContext>, String> {

        private String destination;

        BuildDictionaryWorker(String destination) {
            this.destination = destination;
        }

        @Override
        protected TreeBranch<DictionaryContext> doInBackground() throws Exception {
            return commandListener.buildDictionaryTree(destination);
        }

        @Override
        public void done() {
            try {
                dictionaryTree = get();
                if (dictionaryTree != null){
                    setModel(new DefaultTreeModel(dictionaryTree));
                }
               // revalidate();
                //repaint();
                
            } catch (InterruptedException | ExecutionException ex) {
                java.util.logging.Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }
    
    private class CommandTreeRenderer extends DefaultTreeCellRenderer{
        boolean isEM;

        CommandTreeRenderer(boolean isEM) {
            super();
            this.isEM = isEM;
        }
        
        void setEM(boolean isEM){
            this.isEM = isEM;
        }
        
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if(!isEM){
                if ((TreeBranch<DictionaryContext>)value == getModel().getRoot() || 
                        (TreeBranch<DictionaryContext>)value == ((TreeBranch<DictionaryContext>)getModel().getRoot()).getChildAt(0)){
                    setForeground(Color.BLACK);
                }
                else {
                    setForeground(Color.GRAY);
                }
            }
            else {
                setForeground(Color.BLACK);
            }
            return this;
        }
    }
    
}