/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.plugin.jas3.console.AlarmListener;
import org.lsst.ccs.plugin.jas3.console.CommandConsole;
import org.lsst.ccs.plugin.jas3.console.Tracer;
import org.lsst.ccs.utilities.logging.Logger;
import org.xml.sax.SAXException;

public class LsstConsolePlugin
extends Plugin {
    private String defaultConsoleName = "LSST Console";
    private String defaultTracerName = "LSST Tracer";
    private MessagingFactory messagingFactory;
    private Logger logger = Logger.getLogger((String)"org.lsst.ccs.ui");

    protected void init() throws SAXException, IOException {
        Studio studio = this.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add((Object)this);
        studio.getCommandTargetManager().add((CommandGroup)new ConsoleCommands());
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("LsstConsolePlugin.menus");
        builder.build(xml);
    }

    protected void postInit() {
        super.postInit();
        this.messagingFactory = MessagingFactory.getInstance().forSubsystem("__");
        this.messagingFactory.addStatusListener((StatusListens)new AlarmListener(this.getApplication()));
    }

    private Console createCommandConsole(String name) {
        Studio studio = this.getApplication();
        try {
            FreeHEPLookup lookup = studio.getLookup();
            ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
            if (cs != null) {
                Console console = cs.createConsole(name, null);
                final CommandConsole command = new CommandConsole(console);
                Thread t = new Thread("ConsoleInput-" + name){

                    @Override
                    public void run() {
                        try {
                            command.start();
                            command.runConsole();
                        }
                        catch (HardwareException ex) {
                            LsstConsolePlugin.this.logger.severe((Object)"Problems initializing the JAS3 Console", (Throwable)ex, new String[0]);
                            throw new RuntimeException(ex);
                        }
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception e) {
            studio.error("Failed to start Console: " + name, (Throwable)e);
        }
        return null;
    }

    private Console createTracerConsole(String name) {
        FreeHEPLookup lookup = this.getApplication().getLookup();
        ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
        if (cs != null) {
            Tracer tracer = new Tracer(this.messagingFactory);
            Console console = cs.createConsole(name, null, (HasPopupItems)tracer);
            ConsoleOutputStream out = console.getOutputStream(null);
            PrintWriter pw = new PrintWriter((OutputStream)out, true);
            cs.getPageContextForConsole(console).addPageListener((PageListener)tracer);
            tracer.start(pw);
            return console;
        }
        return null;
    }

    public class ConsoleCommands
    extends CommandProcessor {
        public void onLsstConsole() {
            LsstConsolePlugin.this.createCommandConsole(LsstConsolePlugin.this.defaultConsoleName);
        }

        public void onLsstTracer() {
            LsstConsolePlugin.this.createTracerConsole(LsstConsolePlugin.this.defaultTracerName);
        }
    }
}

