package org.lsst.ccs.plugin.jas3.jms;

import java.awt.Component;
import javax.swing.JOptionPane;

/**
 * A preferences panel for setting JMS preferences.
 * @author tonyj
 */
class JmsPreferencesPanel extends javax.swing.JPanel {
    private final JmsPreferences prefs;

    /**
     * Creates new form JmsPreferencesPanel
     */
    JmsPreferencesPanel(JmsPreferences prefs) {
        this.prefs = prefs;
        initComponents();
        setEnabled();
    }
    
        /**
     * Write any changes back into the preferences
     */
    void apply() {
        boolean transportChanged = jmsTransportCheckbox.isSelected() != prefs.isUseTransport();
        final int newPort = ((Number) portSpinner.getValue()).intValue();
        boolean serverOrPortChanged = newPort != prefs.getJmsPort() || !serverTextField.getText().equals(prefs.getJmsServer());
        prefs.setJmsPort(newPort);
        prefs.setJmsServer(serverTextField.getText());
        prefs.setUseTransport(jmsTransportCheckbox.isSelected());
        if (transportChanged || serverOrPortChanged) {
           JOptionPane.showMessageDialog(this, "Console must be restarted for transport change to take effect.");
        }
    }
    
    private void setEnabled() {
        final boolean enabled = jmsTransportCheckbox.isSelected();
        jPanel1.setEnabled(enabled);
        for (Component c : jPanel1.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jmsTransportCheckbox = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        serverTextField = new javax.swing.JTextField();
        javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
        portSpinner = new javax.swing.JSpinner();

        jmsTransportCheckbox.setSelected(prefs.isUseTransport());
        jmsTransportCheckbox.setText("Use JMS transport (rather than default)");
        jmsTransportCheckbox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jmsTransportCheckboxActionPerformed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("JMS properties"));

        jLabel1.setText("Server:");

        serverTextField.setText(prefs.getJmsServer());

        jLabel2.setText("Port:");

        portSpinner.setModel(new javax.swing.SpinnerNumberModel(prefs.getJmsPort(),1,65535,1));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addGap(4, 4, 4)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(serverTextField)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(portSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(serverTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(portSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jmsTransportCheckbox)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jmsTransportCheckbox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jmsTransportCheckboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jmsTransportCheckboxActionPerformed
        if (!prefs.canUseTransport()) {
            JOptionPane.showMessageDialog(this, "Transport not available.");
            jmsTransportCheckbox.setSelected(false);
        }
        setEnabled();
    }//GEN-LAST:event_jmsTransportCheckboxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox jmsTransportCheckbox;
    private javax.swing.JSpinner portSpinner;
    private javax.swing.JTextField serverTextField;
    // End of variables declaration//GEN-END:variables
}
