package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.utilities.logging.Logger;
import org.xml.sax.SAXException;


/**
 *
 * @author F
 */
public class LsstDictionaryPlugin extends Plugin {

    private String defaultConsoleName = "LSST Dictionary";
    DictionaryBusMaster dictionaryBusMaster;
    FreeHEPLookup lookup;
    private Logger logger = Logger.getLogger("org.lsst.ccs.ui");
    private Studio studio;

    @Override
    protected void init() throws SAXException, IOException {

        studio = getApplication();
//        FreeHEPLookup lookup = studio.getLookup();
//        lookup.add(this);
        
        studio.getCommandTargetManager().add(new LsstDictionaryPlugin.DictionaryCommands());

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstDictionaryPlugin.menus");
        builder.build(xml);
    }
    
     @Override
    protected void postInit() {
        super.postInit();
    }
    
    private void createDictionaryDialog(String name) {
        dictionaryBusMaster = new DictionaryBusMaster("dictionary-interface");
        dictionaryBusMaster.initGUI();
        studio.getPageManager().openPage(dictionaryBusMaster.getMainPane(), "Dictionary Interface", null);
        studio.getPageManager().addPageListener(event -> {
            if (event.getID() == PageEvent.PAGECLOSED){ // tab closed
                Component c = event.getPageContext().getPage();
                if (c.equals(dictionaryBusMaster.getMainPane())){
                    try {
                        dictionaryBusMaster.shutdown();
                    } catch (HardwareException ex) {
                        logger.error("dictionary Interface not stopped", ex, "SHUTDOWN");
                    }
                }
            }
        });
    }
    
  public class DictionaryCommands extends CommandProcessor {

        public void onLsstDictionary() {
            createDictionaryDialog(defaultConsoleName);
        }

    }  

}
