package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.lsst.ccs.bus.Agent;

/**
 *
 * @author emarin
 */
public class AgentTable extends JTable implements ItemListener {

    private static final Object[] columnNames = {"agentName","isEM"};
    private EngineeringModeButtonRenderer buttonRenderer;
    private AgentDefaultTableModel tableModel = new AgentDefaultTableModel(columnNames, 0);
    private TableRowSorter<AgentDefaultTableModel> sorter = new TableRowSorter<AgentDefaultTableModel>(tableModel);
    private boolean[] checkSelected = new boolean[Agent.AgentType.values().length];

    public AgentTable() {

        setModel(tableModel);
        setRowSorter(sorter);
        buttonRenderer = new EngineeringModeButtonRenderer();
        getColumn("isEM").setCellRenderer(buttonRenderer);
        getColumn("isEM").setCellEditor(new EngineeringModeButtonEditor());
        getColumn("isEM").setPreferredWidth(20);
        getColumn("agentName").setCellRenderer(new DefaultTableCellRenderer() {

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null){
                    setText(((Agent)value).getName());
                    setToolTipText(((Agent)value).getName());
                }
                return this;
            }
        }
         
        );
        getColumn("agentName").setPreferredWidth(200);
        setRowHeight(27);
        
        setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
//        setCellSelectionEnabled(true);
        this.setShowGrid(false);
        this.setTableHeader(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox checkBox = (JCheckBox)e.getSource();
        String name = checkBox.getName();
        Agent.AgentType type = Agent.AgentType.valueOf(name);
        checkSelected[type.id()]=checkBox.isSelected();

        // Create array of filters
        ArrayList<RowFilter<AgentDefaultTableModel,Integer>> filterList = new ArrayList<RowFilter<AgentDefaultTableModel,Integer>>();
    
        
        for (Agent.AgentType agentType : Agent.AgentType.values()){

                if (checkSelected[agentType.ordinal()]){
                    filterList.add(new RowFilter<AgentDefaultTableModel,Integer>(){
                        
                        @Override
                        public boolean include(RowFilter.Entry<? extends AgentDefaultTableModel, ? extends Integer> entry) {
                            Agent agent = (Agent)entry.getModel().getValueAt(entry.getIdentifier(), 0);
                            if (agent.getType().equals(agentType)){
                                return true;
                            }
                            else return false;
                        }
                        
                    });
                }
        }
        
        // update Filter
        RowFilter filter;
        filter = RowFilter.orFilter(filterList);
        sorter.setRowFilter(filter);
    }
    
    
    
}