package org.lsst.ccs.plugin.jas3.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import java.io.PrintWriter;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.subsystems.console.BaseConsole;

/**
 * This class extends BaseConsole from CCS core, and adds JAS specific 
 * functionality. Much confusion ensues from the fact the fact that this
 * is a CCS console, which displays its output in a JAS console (same name
 * different meaning).
 * @author tonyj
 */

class CommandConsole extends BaseConsole {

    private BufferedReader rdr;
    private PrintWriter pw;
    private final Console console;
    
    /**
     * Create a CommandConsole. 
     * @param console The JAS console (GUI) where this CCS console will be displayed.
     */
    CommandConsole(Console console) {
        this.rdr = new BufferedReader(new InputStreamReader(console.getInputStream("console>")));
        ConsoleOutputStream out = console.getOutputStream(null);
        this.pw = new PrintWriter(out, true);
        this.console = console;
    }

   
    void runConsole() throws HardwareException {
        pw.println("Console ready, locking key = " + getMessagingFactory().getToken());
        while (true) {
            try {
                String line = rdr.readLine();
                if (line == null) {
                    // Getting a null here indicates that the input stream has been closed, 
                    // meaning that the JAS console has been closed
                    break;
                }
                line = line.trim();
                if ("quit".equals(line) || "exit".equals(line)) {
                    // Closing the console should result in the associated input stream being closed
                    // which should cause readline above to return null next time it is called.
                    console.close();
                } else if (!"".equals(line)) {
                    execute(line);
                }
            } catch (IOException e) {
                // FIXME: Should we just log this instead of printing it on the console?
                // Hopefully it will rarely happen anyway.
                pw.println(e);
            }
        }
        shutdown();
    }

    @Override
    protected void message(String message, boolean isError) {
        // FIXME: We could use a stream with different attributes to write
        // errors (for example in red)
        pw.println(message);
    }

    @Override
    protected void messageFromBus(String message) {
        pw.println(message);
    }
}
