/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Font;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLTextPane
extends JTextPane {
    private static final int MAX_LENGTH = 10000;
    HTMLEditorKit kit;
    HTMLDocument doc;

    public HTMLTextPane() {
        this.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.doc = new HTMLDocument();
        this.setEditorKit(this.kit);
        Font font = new Font("Monospaced", 0, 15);
        String bodyrule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt;}";
        this.doc.getStyleSheet().addRule(bodyrule);
        this.setDocument(this.doc);
    }

    public void insertHTML(String s) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), s, 0, 0, null);
            int overLength = this.doc.getLength() - 10000;
            if (overLength > 0) {
                this.removeOverLength(overLength);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(HTMLTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HTMLTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void removeOverLength(int overLength) throws BadLocationException {
        this.doc.remove(0, overLength);
    }
}

