/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.plugin.jas3.trending.LsstTrendingPlugin;
import org.lsst.ccs.plugin.jas3.trending.Plot;
import org.lsst.ccs.plugin.jas3.trending.PlotMaker;
import org.lsst.ccs.plugin.jas3.trending.TrendingPreferences;

public final class AutoRefresh {
    private final PlotMaker plotMaker;
    private final DelayQueue<RegionUpdate> queue = new DelayQueue();
    private final Set<PlotRegion> set = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final Runnable dataFetcher = new DataFetcher();
    private Thread dataFetcherThread;
    private volatile long[] delayBounds;

    public AutoRefresh(LsstTrendingPlugin plugin) {
        this.plotMaker = plugin.getPlotMaker();
        TrendingPreferences pref = plugin.getPreferences();
        this.setDelay(pref.refreshMin(), pref.refreshMax(), TimeUnit.SECONDS);
    }

    public void setDelay(long min, long max, TimeUnit unit) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.delayBounds = min == max ? new long[]{TimeUnit.MILLISECONDS.convert(min, unit)} : new long[]{TimeUnit.MILLISECONDS.convert(min, unit), TimeUnit.MILLISECONDS.convert(max, unit)};
    }

    public synchronized void start() {
        this.stop();
        Studio studio = (Studio)Studio.getApplication();
        PageManager pm = studio.getPageManager();
        List pcList = pm.pages();
        for (Object o : pcList) {
            try {
                PlotPage page = (PlotPage)((PageContext)o).getPage();
                int i = 0;
                while (i < page.numberOfRegions()) {
                    PlotRegion region = page.region(i);
                    this.schedule(region);
                    ++i;
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {}
        }
        this.dataFetcherThread = new Thread(this.dataFetcher, "Auto-refresh");
        int priority = Math.min(Thread.currentThread().getPriority() - 1, 4);
        this.dataFetcherThread.setPriority(Math.max(priority, 1));
        this.dataFetcherThread.start();
        this.plotMaker.setAutorefresh(this);
    }

    public synchronized void stop() {
        this.plotMaker.setAutorefresh(null);
        if (this.dataFetcherThread != null) {
            this.dataFetcherThread.interrupt();
            this.dataFetcherThread = null;
        }
        this.queue.clear();
    }

    public void schedule(PlotRegion region) {
        if (region == null) {
            return;
        }
        Plotter p = region.currentPlot();
        if (p == null) {
            return;
        }
        PlotPage page = null;
        long delay = Long.MAX_VALUE;
        for (Object o : p.getData()) {
            try {
                Plot pd = (Plot)o;
                if (pd.getTimeWindow().isFixed()) continue;
                if (page == null) {
                    page = pd.getPage();
                    boolean isRegionDisplayed = false;
                    int i = 0;
                    while (i < page.numberOfRegions()) {
                        PlotRegion r = page.region(i);
                        if (r == region) {
                            isRegionDisplayed = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isRegionDisplayed) {
                        return;
                    }
                }
                delay = Math.min(delay, this.getDelay(pd));
            }
            catch (ClassCastException classCastException) {}
        }
        this.schedule(region, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(PlotRegion region, long delay, TimeUnit unit) {
        RegionUpdate ru = new RegionUpdate(TimeUnit.MILLISECONDS.convert(delay, unit), region);
        Set<PlotRegion> set = this.set;
        synchronized (set) {
            if (this.set.add(region)) {
                this.queue.add(ru);
            }
        }
    }

    private long getDelay(Plot pd) {
        if (this.delayBounds.length == 1) {
            return this.delayBounds[0];
        }
        long delay = Math.round(pd.getGranularity() * 1.1);
        return Math.min(this.delayBounds[1], Math.max(delay, this.delayBounds[0]));
    }

    private class DataFetcher
    implements Runnable {
        private DataFetcher() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Plotter plotter;
                        RegionUpdate ru = (RegionUpdate)AutoRefresh.this.queue.take();
                        final PlotRegion region = ru.getRegion();
                        AutoRefresh.this.set.remove(region);
                        if (region == null || (plotter = region.currentPlot()) == null) continue;
                        boolean needUpdate = false;
                        for (Object plottedObject : plotter.getData()) {
                            try {
                                Plot pd = (Plot)plottedObject;
                                needUpdate = pd.refresh() || needUpdate;
                            }
                            catch (ClassCastException classCastException) {}
                        }
                        if (!needUpdate) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AutoRefresh.this.plotMaker.refresh(region, null);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    private static class RegionUpdate
    implements Delayed {
        long updateTime;
        WeakReference<PlotRegion> region;

        RegionUpdate(long delay, PlotRegion region) {
            this.updateTime = delay + System.currentTimeMillis();
            this.region = new WeakReference<PlotRegion>(region);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.updateTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            RegionUpdate other = (RegionUpdate)o;
            long delta = this.updateTime - other.updateTime;
            return delta < 0L ? -1 : (delta > 0L ? 1 : 0);
        }

        PlotRegion getRegion() {
            return (PlotRegion)this.region.get();
        }

        public boolean equals(Object obj) {
            return obj instanceof RegionUpdate ? ((RegionUpdate)obj).region.get() == this.region : false;
        }
    }
}

