/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreeMainPanel;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryTreePanel
extends JTree {
    private CommandListener commandListener;
    private TreeBranch<DictionaryContext> dictionaryTree;
    private CommandTreeRenderer renderer;

    public DictionaryTreePanel(CommandListener cmdListener) {
        this.setModel(new DefaultTreeModel((TreeNode)this.dictionaryTree));
        this.commandListener = cmdListener;
        this.getSelectionModel().setSelectionMode(1);
        this.renderer = new CommandTreeRenderer(false);
        this.setCellRenderer(this.renderer);
    }

    public void updateRendererAndData(boolean isEM, String selectedSubsystem) {
        this.renderer.setEM(isEM);
        new BuildDictionaryWorker(selectedSubsystem).execute();
    }

    public void updateRenderer(boolean isEM) {
        this.renderer.setEM(isEM);
        this.revalidate();
        this.repaint();
    }

    private class BuildDictionaryWorker
    extends SwingWorker<TreeBranch<DictionaryContext>, String> {
        private String destination;

        BuildDictionaryWorker(String destination) {
            this.destination = destination;
        }

        @Override
        protected TreeBranch<DictionaryContext> doInBackground() throws Exception {
            return DictionaryTreePanel.this.commandListener.buildDictionaryTree(this.destination);
        }

        @Override
        public void done() {
            try {
                DictionaryTreePanel.this.dictionaryTree = (TreeBranch)this.get();
                if (DictionaryTreePanel.this.dictionaryTree != null) {
                    DictionaryTreePanel.this.setModel(new DefaultTreeModel((TreeNode)DictionaryTreePanel.this.dictionaryTree));
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class CommandTreeRenderer
    extends DefaultTreeCellRenderer {
        boolean isEM;

        CommandTreeRenderer(boolean isEM) {
            this.isEM = isEM;
        }

        void setEM(boolean isEM) {
            this.isEM = isEM;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!this.isEM) {
                if ((TreeBranch)value == DictionaryTreePanel.this.getModel().getRoot() || (TreeBranch)value == ((TreeBranch)DictionaryTreePanel.this.getModel().getRoot()).getChildAt(0)) {
                    this.setForeground(Color.BLACK);
                } else {
                    this.setForeground(Color.GRAY);
                }
            } else {
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }
}

