package org.lsst.ccs.plugin.jas3.rest;

import java.util.logging.Logger;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;

/**
 * This plugin deals with attaching to the restful interfaces, and fetching and 
 * displaying trending data.
 * @author tonyj
 */
public class LsstRestPlugin extends Plugin {

    private static final Logger logger = Logger.getLogger(LsstRestPlugin.class.getName());
    private RestPreferences prefs;
    private Studio studio;
    

    @Override
    protected void init() {
        logger.finest("LSSTRestPlugin created");
        studio = getApplication();        
        prefs = new RestPreferences(studio);
        
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(new RestPreferencesTopic(prefs));
    }

    @Override
    protected void postInit() {
        if (prefs.isConnectOnStartup()) {
            RestConnector connector = new RestConnector(studio, prefs);
            Thread t = new Thread(connector);
            t.start();
        }
    }
}
