package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author emarin
 */
public class EngineeringModeButtonEditor extends AbstractCellEditor implements TableCellEditor, ActionListener {
    private JToggleButton button;
    
    public EngineeringModeButtonEditor() {
        button = new JToggleButton();
        button.setOpaque(true);
        button.addActionListener(this);
    }
    
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {
        button.setSelected((boolean)value);
        String s;
        if ((boolean)value){
           s = "/org/lsst/ccs/plugin/jas3/dictionary/ic_settings_red_18dp.png";
        }
        else {
            s = "/org/lsst/ccs/plugin/jas3/dictionary/ic_settings_black_18dp.png";
        }
        button.setToolTipText("switch to Engineering/Normal mode");
       // button.setText((boolean)value?"Engineering":"Normal");
        return button;
    }
    
    public Object getCellEditorValue() {
        return button.isSelected();
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        fireEditingStopped();
        
    }

}
