package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryBusMaster extends BusMaster {

    private SynchronousCommandAgent syncAgent;
//    private CommandPresenceAgent cpa;
    private DictionaryTreeMainPanel mainPanel;
    private static boolean useSystemLookAndFeel = true;


    public DictionaryBusMaster(String name) {
        super(name,Agent.AgentType.CONSOLE);
        this.syncAgent = new SynchronousCommandAgent(this.fac);
        this.setStatusBroadcastPeriod(0);
        
        // Command Presence Agent initialization : not used anymore
        //      cpa = new CommandPresenceAgent(fac);
        


        mainPanel = new DictionaryTreeMainPanel(new CommandListener() {
        
        
            @Override
            public String sendCommand(String cmdName, Object[] cmdArgs, String destination) {
                return executeSyncInvoke(cmdName, cmdArgs, destination);
            }

            @Override
            public Object[][] getConnectedAgents() {
                return busMasterGetConnectedAgents();
            }

            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return busMasterBuildDictionaryTree(destination);
            }
            
            @Override
            public boolean isInEngineeringMode(String destination){
                Object res = executeInternalSyncInvoke("isInEngineeringMode", new Object[0], destination);
                if (res instanceof Boolean){
                    return (Boolean)res;
                } else {
                    return false;
                }
            }
        });
        
        getAgentPresenceManager().addAgentPresenceListener(mainPanel);
    }
    
    public DictionaryTreeMainPanel getMainPane(){
        return mainPanel;
    }

    public void initGUI() {
        //setName("ModelGUIModule");
        setListenToStatus(true);
        setStatusBroadcastPeriod(10);
        start();
    }


    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }
    public Object[][] busMasterGetConnectedAgents() {
        List<Agent> agentList= getAgentPresenceManager().listAgent(0);
        Object isEM;
        int i = 0;
        Object[][] res = new Object[agentList.size()][2];
        for (Agent a : agentList){
            // TODO : the agent may have disappeared in the meantime
             isEM = executeInternalSyncInvoke("isInEngineeringMode", new Object[0], a.getName());
                if (!(isEM instanceof Boolean)){
                    isEM = false;
                }
            res[i][0]=a;
            res[i][1]=isEM;
            i++;
        }
        return res;
    }
    
    public TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {
        
        TreeBranch<DictionaryContext> dictionaryTree = null;
        
        // Root Node building
        Object systemDictionary = executeInternalSyncInvoke("getSystemDictionary", new Object[0], destination);
        if (systemDictionary instanceof Dictionary){
            
            dictionaryTree = new TreeBranch<DictionaryContext>(new DictionaryContext(destination, (Dictionary)systemDictionary));
            
            // Dictionary Tree Building
            Object modularSubsystemDictionary = executeInternalSyncInvoke("getComponentDictionariesTree", new Object[0], destination);
            if (modularSubsystemDictionary instanceof TreeBranch<?>){
                dictionaryTree.addChild((TreeBranch<DictionaryContext>)modularSubsystemDictionary);
            }
        }
        return dictionaryTree;
    }

    public Object executeInternalSyncInvoke(String cmdName, Object[]p,String destination){
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(cmdName, p);
        cmd.setDestination(destination);
        cmd.setCanRunInActiveMode(false);
        try {
           return syncAgent.invoke(cmd, 5000);
        } catch (Exception e) {
            message(" Exception caught :" + StackTraceFormats.toString(e, 1), true);
            return null;
        }

    }
    
    public String executeSyncInvoke(String cmdName, Object[] p, String destination) {

        ModuleInvokerCommand cmd = new ModuleInvokerCommand(cmdName, p);
        cmd.setDestination(destination);
        cmd.setCanRunInActiveMode(false);
        try {
            Object res = syncAgent.invoke(cmd, 5000);
            // in fact if this is an exception should mark as error!
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Exception) res, 1);
                message("error?: " + strRes, true);
            } else if (res == null) {
                strRes = "ok : VOID";
                message(strRes, false);
            } else {
                strRes = String.valueOf(res);
                message("result: " + strRes, false);
            }
            return strRes;
        } catch (Exception e) {
            message(" Exception caught :" + StackTraceFormats.toString(e, 1), true);
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString(e, 1) + "</font></html>";
        }
    }
    
    protected void message(String str, boolean isError) {
        (isError ? System.err : System.out).println(str);
    }

    @Override
    public void onReply(CommandReply cmd) {
        String rep = "\nReply message from " + cmd.getOrigin();
        rep += "\nCorrelID: " + cmd.getCorrelId();
        rep += "\nStatus         : " + cmd.getStatus();
        Object res = cmd.getReply();
        if (res instanceof Exception) {
            rep += "\nException:" + StackTraceFormats.toString((Exception) res, 1);
        } else if (res == null) {
            rep += "\nReply          : VOID";
        } else {
            rep += "\nReply          : " + res;
        }
        // rep += "\nCorrelId       : "+cmd.getCorrelId();
        messageFromBus(rep);
    }

    /**
     * to be overridden
     *
     * @param message
     */
    protected void messageFromBus(String message) {
        System.out.println(message);
    }
}
