package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.lsst.ccs.bus.Agent;

/**
 *
 * @author emarin
 */
public class AgentTable extends JTable {

    private static final Object[] columnNames = {"agentName","isEM"};
    private CommandListener commandListener;
    EngineeringModeButtonRenderer buttonRenderer;

    public AgentTable(CommandListener cmdListener) {

        setModel(new AgentDefaultTableModel(columnNames,0));

        buttonRenderer = new EngineeringModeButtonRenderer();
        getColumn("isEM").setCellRenderer(buttonRenderer);
        getColumn("isEM").setCellEditor(new EngineeringModeButtonEditor());
        getColumn("isEM").setPreferredWidth(20);
        getColumn("agentName").setCellRenderer(new DefaultTableCellRenderer() {

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null){
                    setText(((Agent)value).getName());
                    setToolTipText(((Agent)value).getName());
                }
                return this;
            }
        }
         
        );
        getColumn("agentName").setPreferredWidth(200);
        setRowHeight(27);
        
        setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
//        setCellSelectionEnabled(true);
        this.setShowGrid(false);
        this.setTableHeader(null);
        
        this.commandListener = cmdListener;
    }

    
    
    
}