package org.lsst.ccs.plugin.jas3.console;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.DetailLevel;
import org.lsst.ccs.bus.StatusListener;

/**
 * Listen for alarms on the status bus, and if/when found popup an alarm dialog
 * @author tonyj
 */
class AlarmListener implements StatusListener, Runnable {

    private final Studio studio;
    private JDialog dialog;
    private final Console console;
    private final PrintWriter printWriter;

    public AlarmListener(Studio studio) {
        this.studio = studio;
        console = new Console();
        printWriter = new PrintWriter(new OutputStreamWriter(console.getOutputStream(null)),true);
    }
    
    
    @Override
    public void onStatus(BusMessage bm) {
        // FIXME: What is the right test for alarm?
        if (bm.getDetailLevel() == DetailLevel.SEVERE) {
            ensureDialogVisible();
            printWriter.println(bm);
        }
    }

    @Override
    public void run() {
        if (dialog == null) {
            dialog = createDialog();
        }
        if (!dialog.isVisible()) {
            dialog.setVisible(true);
        }      
    }

    private void ensureDialogVisible() {
        SwingUtilities.invokeLater(this);
    }

    private JDialog createDialog() {
        JOptionPane pane = new JOptionPane();
        pane.setMessageType(JOptionPane.ERROR_MESSAGE);
        pane.setOptions(new Object[]{"Clear Alarm"});
        pane.setMessage(new JScrollPane(console));
        JDialog dlg = pane.createDialog(studio, "Alarm");
        dlg.setResizable(true);
        dlg.setModal(false);
        dlg.setAlwaysOnTop(true);
        return dlg;
    }
}
