/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.plugin.jas3.trending.timeselection.PresetList;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindow;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindowPanel;

public class PresetsDialog {
    private final int VSPACE = 5;
    private final int HSPACE = 10;
    private final JScrollPane root;
    private final JButton editButton;
    private final JButton deleteButton;
    private final JButton newButton;
    private final JButton okButton;
    private final JTable table;
    private final PresetList timeWindowList;
    private TimeWindow selectedTimeWindow;

    private PresetsDialog(PresetList data) {
        this.timeWindowList = data;
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindow ts = PresetsDialog.this.getSelectedPreset();
                ts = TimeWindowPanel.editTimeWindow(PresetsDialog.this.editButton, ts);
                if (ts != null) {
                    PresetsDialog.this.timeWindowList.insert(ts);
                    PresetsDialog.this.setSelectedPreset(ts);
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindow ts = PresetsDialog.this.getSelectedPreset();
                if (ts != null) {
                    PresetsDialog.this.timeWindowList.delete(ts);
                }
            }
        });
        this.newButton = new JButton("New...");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindow ts = TimeWindowPanel.editTimeWindow(PresetsDialog.this.newButton, null);
                if (ts != null) {
                    PresetsDialog.this.timeWindowList.insert(ts);
                    PresetsDialog.this.setSelectedPreset(ts);
                }
            }
        });
        this.okButton = new JButton("  OK  ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetsDialog.this.selectedTimeWindow = PresetsDialog.this.getSelectedPreset();
                Window w = SwingUtilities.getWindowAncestor(PresetsDialog.this.okButton);
                if (w != null) {
                    w.setVisible(false);
                }
            }
        });
        this.table = new JTable(this.timeWindowList);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TimeWindow ts = PresetsDialog.this.getSelectedPreset();
                PresetsDialog.this.editButton.setEnabled(ts != null);
                PresetsDialog.this.deleteButton.setEnabled(ts != null);
            }
        });
        this.root = new JScrollPane(this.table);
    }

    public static TimeWindow managePresets(Component parent, PresetList data) {
        PresetsDialog dialog = new PresetsDialog(data);
        JOptionPane.showOptionDialog(parent, dialog.root, "Trending Time Window Presets", -1, -1, null, new JButton[]{dialog.editButton, dialog.deleteButton, dialog.newButton, dialog.okButton}, dialog.okButton);
        return dialog.selectedTimeWindow;
    }

    private TimeWindow getSelectedPreset() {
        int index = this.table.getSelectedRow();
        return index == -1 ? null : this.timeWindowList.get(index);
    }

    private void setSelectedPreset(TimeWindow ts) {
        int index = this.timeWindowList.indexOf(ts);
        if (index == -1) {
            this.table.getSelectionModel().clearSelection();
        } else {
            this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }
}

