/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import hep.aida.IAnnotation;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IPlotterStyle;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.lsst.ccs.plugin.jas3.trending.DataChannelHandler;
import org.lsst.ccs.plugin.jas3.trending.PlotData;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindow;

public final class Plot
implements IDataPointSet {
    IPlotterStyle ALARM_STYLE;
    IPlotterStyle WARNING_STYLE;
    private PlotData data;
    private final TimeWindow timeWindow;
    private final DataChannelHandler channel;
    private PlotPage page;
    private PlotRegion region;
    private double low = -1.0;
    private double high = -1.0;
    private PlotData spareData;
    private double spareLow = -1.0;
    private double spareHigh = -1.0;

    public Plot(PlotData data, TimeWindow timeWindow, DataChannelHandler channel) {
        this(data, timeWindow, channel, null, null);
    }

    public Plot(PlotData data, TimeWindow timeWindow, DataChannelHandler channel, PlotPage page, PlotRegion region) {
        this.data = data;
        this.timeWindow = timeWindow;
        this.channel = channel;
        this.page = page;
        this.region = region;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public DataChannelHandler getChannel() {
        return this.channel;
    }

    public PlotPage getPage() {
        return this.page;
    }

    public void setPage(PlotPage page) {
        this.page = page;
    }

    public PlotRegion getRegion() {
        return this.region;
    }

    public void setRegion(PlotRegion region) {
        this.region = region;
    }

    public void setTimeRange(long begin, long end) {
        this.low = begin;
        this.high = end;
    }

    public double getGranularity() {
        int n = this.size();
        if (n < 2) {
            return (this.upperExtent(0) - this.lowerExtent(0)) / 100.0;
        }
        return (this.upperExtent(0) - this.lowerExtent(0)) / (double)n;
    }

    public boolean refresh() {
        if (this.data == this.spareData) {
            return false;
        }
        if (this.spareData == null && !this.channel.refresh(this)) {
            return false;
        }
        this.data = this.spareData;
        this.low = this.spareLow;
        this.high = this.spareHigh;
        this.spareData = null;
        this.spareLow = -1.0;
        this.spareHigh = -1.0;
        return true;
    }

    public void prepareRefresh(PlotData data) {
        this.prepareRefresh(data, -1L, -1L);
    }

    public void prepareRefresh(PlotData data, long begin, long end) {
        this.spareData = data;
        this.spareLow = begin;
        this.spareHigh = end;
    }

    public void showExtra() {
    }

    public void hideExtra() {
    }

    public IAnnotation annotation() {
        return this.data.getValue().annotation();
    }

    public String title() {
        return this.channel.getPath();
    }

    public void setTitle(String string) throws IllegalArgumentException {
        this.data.getValue().setTitle(string);
    }

    public int dimension() {
        return this.data.getValue().dimension();
    }

    public void clear() {
        this.data.getValue().clear();
    }

    public int size() {
        return this.data.getValue().size();
    }

    public IDataPoint point(int i) {
        return this.data.getValue().point(i);
    }

    public void setCoordinate(int i, double[] doubles, double[] doubles1) throws IllegalArgumentException {
        this.data.getValue().setCoordinate(i, doubles, doubles1);
    }

    public void setCoordinate(int i, double[] doubles, double[] doubles1, double[] doubles2) throws IllegalArgumentException {
        this.data.getValue().setCoordinate(i, doubles, doubles1, doubles2);
    }

    public IDataPoint addPoint() throws RuntimeException {
        return this.data.getValue().addPoint();
    }

    public void addPoint(IDataPoint idp) throws IllegalArgumentException {
        this.data.getValue().addPoint(idp);
    }

    public void removePoint(int i) throws IllegalArgumentException {
        this.data.getValue().removePoint(i);
    }

    public double lowerExtent(int i) throws IllegalArgumentException {
        return i == 0 && this.low > 0.0 ? this.low : this.data.getValue().lowerExtent(i);
    }

    public double upperExtent(int i) throws IllegalArgumentException {
        return i == 0 && this.high > 0.0 ? this.high : this.data.getValue().upperExtent(i);
    }

    public void scale(double d) throws IllegalArgumentException {
        this.data.getValue().scale(d);
    }

    public void scaleValues(double d) throws IllegalArgumentException {
        this.data.getValue().scaleValues(d);
    }

    public void scaleErrors(double d) throws IllegalArgumentException {
        this.data.getValue().scaleErrors(d);
    }
}

