/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.AgentPresenceListener;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreeMainPanel;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryBusMaster
extends BusMaster {
    private SynchronousCommandAgent syncAgent;
    private DictionaryTreeMainPanel mainPanel;
    private static boolean useSystemLookAndFeel = true;

    public DictionaryBusMaster(String name) {
        super(name, Agent.AgentType.CONSOLE);
        this.syncAgent = new SynchronousCommandAgent(this.fac);
        this.setStatusBroadcastPeriod(0);
        this.mainPanel = new DictionaryTreeMainPanel(new CommandListener(){

            @Override
            public String sendCommand(String cmdName, Object[] cmdArgs, String destination) {
                return DictionaryBusMaster.this.executeSyncInvoke(cmdName, cmdArgs, destination);
            }

            @Override
            public Object[][] getConnectedAgents() {
                return DictionaryBusMaster.this.busMasterGetConnectedAgents();
            }

            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return DictionaryBusMaster.this.busMasterBuildDictionaryTree(destination);
            }

            @Override
            public boolean isInEngineeringMode(String destination) {
                Object res = DictionaryBusMaster.this.executeInternalSyncInvoke("isInEngineeringMode", new Object[0], destination);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
                return false;
            }
        });
        this.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.mainPanel);
    }

    public DictionaryTreeMainPanel getMainPane() {
        return this.mainPanel;
    }

    public void initGUI() {
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(10);
        this.start();
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }

    public Object[][] busMasterGetConnectedAgents() {
        List agentList = this.getAgentPresenceManager().listAgent(0);
        int i = 0;
        Object[][] res = new Object[agentList.size()][2];
        for (Agent a : agentList) {
            Object isEM = this.executeInternalSyncInvoke("isInEngineeringMode", new Object[0], a.getName());
            if (!(isEM instanceof Boolean)) {
                isEM = false;
            }
            res[i][0] = a;
            res[i][1] = isEM;
            ++i;
        }
        return res;
    }

    public TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {
        TreeBranch dictionaryTree = null;
        Object systemDictionary = this.executeInternalSyncInvoke("getSystemDictionary", new Object[0], destination);
        if (systemDictionary instanceof Dictionary) {
            dictionaryTree = new TreeBranch((Serializable)new DictionaryContext(destination, (Dictionary)systemDictionary));
            Object modularSubsystemDictionary = this.executeInternalSyncInvoke("getComponentDictionariesTree", new Object[0], destination);
            if (modularSubsystemDictionary instanceof TreeBranch) {
                dictionaryTree.addChild((TreeBranch)modularSubsystemDictionary);
            }
        }
        return dictionaryTree;
    }

    public Object executeInternalSyncInvoke(String cmdName, Object[] p, String destination) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(cmdName, p);
        cmd.setDestination(destination);
        cmd.setCanRunInActiveMode(false);
        try {
            return this.syncAgent.invoke((Command)cmd, 5000L);
        }
        catch (Exception e) {
            this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e, (int)1), true);
            return null;
        }
    }

    public String executeSyncInvoke(String cmdName, Object[] p, String destination) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(cmdName, p);
        cmd.setDestination(destination);
        cmd.setCanRunInActiveMode(false);
        try {
            Object res = this.syncAgent.invoke((Command)cmd, 5000L);
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Throwable)((Exception)res), (int)1);
                this.message("error?: " + strRes, true);
            } else if (res == null) {
                strRes = "ok : VOID";
                this.message(strRes, false);
            } else {
                strRes = String.valueOf(res);
                this.message("result: " + strRes, false);
            }
            return strRes;
        }
        catch (Exception e) {
            this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e, (int)1), true);
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString((Throwable)e, (int)1) + "</font></html>";
        }
    }

    protected void message(String str, boolean isError) {
        (isError ? System.err : System.out).println(str);
    }

    public void onReply(CommandReply cmd) {
        String rep = "\nReply message from " + cmd.getOrigin();
        rep = String.valueOf(rep) + "\nCorrelID: " + cmd.getCorrelId();
        rep = String.valueOf(rep) + "\nStatus         : " + cmd.getStatus();
        Object res = cmd.getReply();
        rep = res instanceof Exception ? String.valueOf(rep) + "\nException:" + StackTraceFormats.toString((Throwable)((Exception)res), (int)1) : (res == null ? String.valueOf(rep) + "\nReply          : VOID" : String.valueOf(rep) + "\nReply          : " + res);
        this.messageFromBus(rep);
    }

    protected void messageFromBus(String message) {
        System.out.println(message);
    }
}

