/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesTreeProperties;

class ResourcesUtils {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    ResourcesUtils() {
    }

    static Properties getMergedPropertyFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedPropertyFile(tree, fileName, false);
    }

    static Properties getMergedPropertyFile(ResourcesTree tree, String fileName, boolean useSystem) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName}, useSystem, null);
    }

    static Properties getMergedProperties(ResourcesTree tree, String[] properties, boolean useSystem, ResourcesTreeProperties parentProps) {
        ResourcesTreeProperties props = parentProps;
        if (useSystem) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding System Properties to the properties chain");
            }
            props = new ResourcesTreeProperties("SystemProperties", null, props);
            props.putAll((Map<?, ?>)System.getProperties());
        }
        try {
            InputStream defaultsIn = Bootstrap.getLoaderClass().getResourceAsStream("/ccsDefaults.properties");
            if (defaultsIn != null) {
                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                    System.out.println("*** Adding Properties " + BootstrapUtils.getDistributionResourcesDirectory() + "ccsDefaults.properties to properties chain");
                }
                ResourcesTreeProperties parent = props;
                props = new ResourcesTreeProperties("ccsDefaults", BootstrapUtils.getDistributionResourcesDirectory(), parent);
                props.load(defaultsIn);
                String applicationName = Bootstrap.getBootstrapApplication();
                props.put("org.lsst.ccs.application.name", applicationName == null ? "" : applicationName);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        ListIterator<ResourceDirectory> reverseIterator = resourceList.listIterator(resourceList.size());
        while (reverseIterator.hasPrevious()) {
            ResourceDirectory dir = reverseIterator.previous();
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyFileName = stringArray[n2];
                if (propertyFileName != null) {
                    File propertyFile;
                    if (!propertyFileName.endsWith(".properties")) {
                        propertyFileName = String.valueOf(propertyFileName) + ".properties";
                    }
                    if (!(propertyFile = new File(dir.getResouceDirectoryPath(), propertyFileName)).exists() && propertyFileName.contains(FILE_SEPARATOR)) {
                        propertyFileName = propertyFileName.substring(propertyFileName.lastIndexOf(FILE_SEPARATOR) + 1);
                        propertyFile = new File(dir.getResouceDirectoryPath(), propertyFileName);
                    }
                    if (propertyFile.exists()) {
                        FileInputStream in = null;
                        try {
                            try {
                                in = new FileInputStream(propertyFile);
                                ResourcesTreeProperties parent = props;
                                props = new ResourcesTreeProperties(propertyFileName, dir.getResouceDirectoryPath(), parent);
                                props.load(in);
                                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                                    System.out.println("*** Adding Properties " + dir.getResouceDirectoryPath() + propertyFileName + " to properties chain");
                                }
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return props;
    }

    static void printProperties(Properties props) {
        ResourcesTreeProperties p;
        System.out.println("*****************");
        if (props instanceof ResourcesTreeProperties) {
            p = (ResourcesTreeProperties)props;
            String output = "Properties from " + p.getPropertyFileName();
            if (p.getResourceDirectory() != null) {
                output = String.valueOf(output) + " in resource directory " + p.getResourceDirectory();
            }
            System.out.println(output);
        } else {
            System.out.println("External System properties");
        }
        for (Object key : props.keySet()) {
            System.out.println("\t" + key + " = " + props.getProperty((String)key));
        }
        if (props instanceof ResourcesTreeProperties && (p = (ResourcesTreeProperties)props).hasParent()) {
            ResourcesUtils.printProperties(p.getParent());
        }
    }

    static void loadKeySetForProperties(Properties props, Set<Object> set) {
        Set<Object> propsKey = props.keySet();
        for (Object obj : propsKey) {
            if (set.contains(obj)) continue;
            set.add(obj);
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)props).getParent() != null) {
            ResourcesUtils.loadKeySetForProperties(((ResourcesTreeProperties)props).getParent(), set);
        }
    }

    static InputStream getResourceFromResourceTree(ResourcesTree tree, String resourceName) throws FileNotFoundException {
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        for (ResourceDirectory dir : resourceList) {
            File resourceFile = new File(String.valueOf(dir.getResouceDirectoryPath()) + resourceName);
            if (!resourceFile.exists() && resourceName.contains(FILE_SEPARATOR)) {
                resourceName = resourceName.substring(resourceName.lastIndexOf(FILE_SEPARATOR) + 1);
                resourceFile = new File(String.valueOf(dir.getResouceDirectoryPath()) + resourceName);
            }
            if (!resourceFile.exists()) continue;
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Found resource " + dir.getResouceDirectoryPath() + resourceName);
            }
            return new FileInputStream(resourceFile);
        }
        return null;
    }
}

