/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.util.waitcursor;

import org.freehep.jas.util.waitcursor.DelayTimerCallback;

class DelayTimer
extends Thread {
    private final DelayTimerCallback callback;
    private final Object mutex = new Object();
    private final Object triggeredMutex = new Object();
    private final long delay;
    private boolean quit;
    private boolean triggered;
    private long waitTime;

    public DelayTimer(DelayTimerCallback callback, long delay) {
        this.callback = callback;
        this.delay = delay;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        Object object = this.mutex;
        synchronized (object) {
            this.quit = true;
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                if (this.quit) break;
                Object object = this.mutex;
                synchronized (object) {
                    if (this.waitTime < 0L) {
                        this.triggered = true;
                        this.waitTime = 0L;
                    } else {
                        long saveWaitTime = this.waitTime;
                        this.waitTime = -1L;
                        this.mutex.wait(saveWaitTime);
                    }
                }
                try {
                    if (!this.triggered) continue;
                    this.callback.trigger();
                }
                catch (Exception e) {
                    System.err.println("trigger() threw exception, continuing");
                    e.printStackTrace(System.err);
                }
                finally {
                    Object e = this.triggeredMutex;
                    synchronized (e) {
                        this.triggered = false;
                        this.triggeredMutex.notify();
                    }
                }
            }
            catch (InterruptedException ie) {
                System.err.println("interrupted in run");
                ie.printStackTrace(System.err);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        Object object = this.mutex;
        synchronized (object) {
            this.waitTime = this.delay;
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.triggeredMutex;
                synchronized (object2) {
                    if (this.triggered) {
                        this.triggeredMutex.wait();
                    }
                }
                this.waitTime = 0L;
                this.mutex.notify();
            }
        }
        catch (InterruptedException ie) {
            System.err.println("trigger failure");
            ie.printStackTrace(System.err);
        }
    }
}

