/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jms;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class QueueSessionFactory {
    protected static QueueSessionFactory instance = null;
    static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.jms.QueueSessionFactory");
    Connection conn;
    Context context;
    ConnectionFactory cf;

    public static synchronized QueueSessionFactory getSessionFactory() {
        if (instance == null) {
            instance = new QueueSessionFactory();
        }
        return instance;
    }

    public Session getQueueSession() {
        try {
            if (this.context == null) {
                Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"jndi");
                this.context = new InitialContext(props);
            }
            if (this.cf == null) {
                this.cf = (ConnectionFactory)this.context.lookup("ConnectionFactory");
            }
            if (this.conn == null) {
                this.conn = this.cf.createConnection();
                this.conn.start();
            }
            Session session = this.conn.createSession(false, 1);
            return session;
        }
        catch (NamingException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        catch (JMSException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public MessageProducer getCommandReplySender(Session sess, Destination dest) {
        try {
            return sess.createProducer(dest);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

