/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jms;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.BusPayload;
import org.lsst.ccs.bus.jms.TopicContextFactory;
import org.lsst.ccs.utilities.logging.Logger;

public class JMSBusMessagingLayer
implements BusMessagingLayer {
    private static Logger logger = Logger.getLogger((String)"org.lsst.ccs.bus.jms.JMSBusMessagingLayer");
    private Map<String, LocalAgent> mapLocalAgent = new ConcurrentHashMap<String, LocalAgent>();

    @Override
    public void close() throws IOException {
        for (String key : this.mapLocalAgent.keySet()) {
            logger.info((Object)("******** removing " + key), new String[0]);
            LocalAgent localAgent = this.mapLocalAgent.get(key);
            JMSConsumer[] jMSConsumerArray = localAgent.consumers;
            int n = localAgent.consumers.length;
            int n2 = 0;
            while (n2 < n) {
                JMSConsumer mc = jMSConsumerArray[n2];
                if (mc != null) {
                    mc.close();
                }
                ++n2;
            }
        }
    }

    @Override
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = this.mapLocalAgent.get((Object)agentName).receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
            ++n2;
        }
    }

    @Override
    public void closeFor(String agentName, Bus ... buses) {
        LocalAgent localAgent;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) != null) {
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus b = busArray[n2];
                int index = b.ordinal();
                localAgent.consumers[index].close();
                localAgent.jmsContext.unsubscribe(agentName);
                ++n2;
            }
        }
    }

    @Override
    public <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, T message, String ... destinations) throws IOException {
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        bus.ordinal();
        JMSContext ctxt = this.mapLocalAgent.get((Object)senderAgent).jmsContext;
        JMSProducer send = ctxt.createProducer();
        if (bus == Bus.COMMAND && destinations.length != 0) {
            String[] stringArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                String dest = stringArray[n2];
                this.sendMessageToDestination(ctxt, message, dest, send, bus);
                ++n2;
            }
        } else {
            this.sendMessageToDestination(ctxt, message, "", send, bus);
        }
    }

    public <T extends BusPayload> void sendMessageToDestination(JMSContext ctxt, T message, String dest, JMSProducer send, Bus<T> bus) {
        ObjectMessage m;
        try {
            m = ctxt.createObjectMessage();
            m.setObject(message);
            if (!dest.isEmpty()) {
                m.setStringProperty("destination", dest);
            }
        }
        catch (JMSException e) {
            logger.error((Object)e, new String[0]);
            throw new RuntimeException(e);
        }
        try {
            m.setJMSMessageID("0");
            m.setJMSPriority(4);
            m.setJMSReplyTo((Destination)TopicContextFactory.getTopicContextFactory().getCommandTopic());
            m.setJMSTimestamp(System.currentTimeMillis());
            String busName = bus.toString();
            send.send((Destination)TopicContextFactory.getTopicContextFactory().getTopic(busName), (Message)m);
        }
        catch (JMSException e) {
            logger.error((Object)"Error sending message", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgent localAgent;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) == null) {
            return;
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgent.receivers[bus.ordinal()];
            if (receiver != null) {
                receiver.removeForwarder(forwarder);
            }
            ++n2;
        }
    }

    @Override
    public void register(String agentName, Bus ... buses) throws IOException {
        LocalAgent localAgent;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        StringBuilder allBuses = new StringBuilder();
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            allBuses.append(bus.toString()).append(" ");
            ++n2;
        }
        logger.info((Object)("### Registering " + agentName + " for buses " + allBuses), new String[0]);
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) == null) {
            localAgent = new LocalAgent();
            localAgent.agentName = agentName;
            this.mapLocalAgent.put(agentName, localAgent);
            logger.debug((Object)"context created", new String[0]);
            localAgent.jmsContext = TopicContextFactory.getTopicContextFactory().createContext(agentName);
        }
        Bus[] busArray2 = buses;
        int n3 = buses.length;
        n = 0;
        while (n < n3) {
            Bus bus = busArray2[n];
            int index = bus.ordinal();
            switch (index) {
                case 0: {
                    localAgent.consumers[0] = TopicContextFactory.getTopicContextFactory().getLogSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[0] = new BusReceiver(agentName, bus, localAgent.consumers[0]);
                    }
                    catch (JMSException jMSException) {
                        logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
                    }
                    break;
                }
                case 1: {
                    localAgent.consumers[1] = TopicContextFactory.getTopicContextFactory().getStatusSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[1] = new BusReceiver(agentName, bus, localAgent.consumers[1]);
                    }
                    catch (JMSException jMSException) {
                        logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
                    }
                    break;
                }
                case 2: {
                    localAgent.consumers[2] = TopicContextFactory.getTopicContextFactory().getCommandSubscriber(localAgent.jmsContext, agentName, "destination='" + agentName + "'");
                    try {
                        localAgent.receivers[2] = new BusReceiver(agentName, bus, localAgent.consumers[2]);
                        break;
                    }
                    catch (JMSException jMSException) {
                        logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
                    }
                }
            }
            ++n;
        }
    }

    class BusReceiver
    implements MessageListener {
        Bus bus;
        JMSConsumer curConsumer;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        String agentName;

        public BusReceiver(String agentName, Bus bus, JMSConsumer curConsumer) throws JMSException {
            this.agentName = agentName;
            this.bus = bus;
            this.curConsumer = curConsumer;
            curConsumer.setMessageListener((MessageListener)this);
        }

        public void addForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                this.listForwarders = new CopyOnWriteArrayList();
            }
            this.listForwarders.add(forwarder);
        }

        public void removeForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                return;
            }
            this.listForwarders.remove(forwarder);
        }

        public void onMessage(Message message) {
            BusMessage busMessInit = null;
            if (this.listForwarders == null) {
                return;
            }
            if (this.listForwarders.isEmpty()) {
                return;
            }
            try {
                busMessInit = (BusMessage)((ObjectMessage)message).getObject();
            }
            catch (JMSException jMSException) {
                logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
            }
            BusMessage busMess = busMessInit;
            if (busMess.getOrigin().equals(this.agentName)) {
                logger.trace((Object)"message received by same agent than sender", new String[0]);
                return;
            }
            for (BusMessageForwarder forwarder : this.listForwarders) {
                forwarder.update(busMess);
            }
        }
    }

    class LocalAgent {
        String agentName;
        JMSContext jmsContext;
        JMSConsumer[] consumers = new JMSConsumer[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgent() {
        }
    }
}

