/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.ValueEvent;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.HollowParm;

@MappedSuperclass
public abstract class ConfigProfile
implements Serializable {
    private long startTimestamp;
    private long endTimestamp = PackCst.STILL_VALID;
    private String name;
    private String subsystemName;
    private String tag;
    private String userName;
    private boolean changingStaticData;
    private boolean beenInEngineeringMode;
    private int level = 5;
    private String remarks;
    private long previousConfigID;

    protected ConfigProfile() {
    }

    protected ConfigProfile(String name, String subsystemName, String tag, String userName, int level) {
        this.name = name;
        this.subsystemName = subsystemName;
        this.tag = tag;
        this.userName = userName;
        this.level = level;
    }

    protected abstract long getId();

    protected abstract void setId(long var1);

    public abstract SubsystemDescription getSubsystemDescription();

    public abstract Set<? extends ParameterConfiguration> getModifiedParameters();

    public abstract void temporaryChangeConfigurationValue(ParameterConfiguration var1, long var2, String var4, boolean var5);

    public abstract ParameterConfiguration temporaryChangeConfigurationValue(String var1, long var2, String var4, boolean var5);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public boolean isBeenInEngineeringMode() {
        return this.beenInEngineeringMode;
    }

    public void setBeenInEngineeringMode(boolean beenInEngineeringMode) {
        this.beenInEngineeringMode = beenInEngineeringMode;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public boolean isChangingStaticData() {
        return this.changingStaticData;
    }

    void setChangingStaticData(boolean changingStaticData) {
        this.changingStaticData = changingStaticData;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        if (this.subsystemName == null || "".equals(this.subsystemName)) {
            this.subsystemName = subsystemName;
        }
    }

    public String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    protected void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public String getUserName() {
        return this.userName;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public long getPreviousConfigID() {
        return this.previousConfigID;
    }

    void setPreviousConfigID(long previousConfigID) {
        this.previousConfigID = previousConfigID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigProfile)) {
            return false;
        }
        ConfigProfile that = (ConfigProfile)o;
        if (this.getId() != that.getId()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        String tag = this.getTag();
        return !(tag != null ? !tag.equals(that.getTag()) : that.getTag() != null);
    }

    public int hashCode() {
        long id = this.getId();
        int result = (int)(id ^ id >>> 32);
        result = 31 * result + this.getName().hashCode();
        String tag = this.getTag();
        result = 31 * result + (tag != null ? tag.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{id=" + this.getId() + "; name=" + this.getName() + "(" + this.getSubsystemDescription().getId() + ")" + ";configurations=" + this.getModifiedParameters() + '}';
    }

    public ParameterConfiguration fetch(PathObject path) {
        for (ParameterConfiguration parameterConfiguration : this.getModifiedParameters()) {
            if (!parameterConfiguration.getPath().equals(path.getPath())) continue;
            return parameterConfiguration;
        }
        return null;
    }

    public ParameterConfiguration fetch(String pathName) {
        return this.fetch(ParameterPath.valueOf(pathName));
    }

    public Map<String, List<ParameterConfiguration>> getConfigurationMap() {
        HashMap<String, List<ParameterConfiguration>> res = new HashMap<String, List<ParameterConfiguration>>();
        for (ParameterConfiguration parameterConfiguration : this.getModifiedParameters()) {
            ParameterPath path = parameterConfiguration.getPath();
            String component = path.getComponentName();
            ArrayList<ParameterConfiguration> presentList = (ArrayList<ParameterConfiguration>)res.get(component);
            if (presentList == null) {
                presentList = new ArrayList<ParameterConfiguration>();
                res.put(component, presentList);
            }
            presentList.add(parameterConfiguration);
        }
        return res;
    }

    public void modifyParameterConfiguration(String pathName, String value) {
        SubsystemDescription curDescr = this.getSubsystemDescription();
        ParameterDescription description = curDescr.fetch(pathName);
        ParameterConfiguration conf = Factories.createParameterConfiguration(description, value);
        this.addParameterConfigurations(conf);
    }

    public List<ParameterConfiguration> getAllReconfigurationFailures() {
        ArrayList<ParameterConfiguration> res = new ArrayList<ParameterConfiguration>();
        for (ParameterConfiguration parameterConfiguration : this.getModifiedParameters()) {
            if (parameterConfiguration.getReConfigurationFailure() == null) continue;
            res.add(parameterConfiguration);
        }
        return res;
    }

    public List<String> reportFailures() {
        ArrayList<String> res = new ArrayList<String>();
        for (ParameterConfiguration config : this.getAllReconfigurationFailures()) {
            res.add(config.getPath() + " : " + config.getReConfigurationFailure());
        }
        return res;
    }

    public void generateConfigProperties(PrintWriter printer) {
        ArrayList<? extends ParameterConfiguration> list = new ArrayList<ParameterConfiguration>(this.getModifiedParameters());
        Collections.sort(list, PathObject.COMPARATOR);
        for (ParameterConfiguration parameterConfiguration : list) {
            boolean commentOut = false;
            if (parameterConfiguration.getValue().equals(parameterConfiguration.getDescription().getDefaultValue())) {
                commentOut = true;
            }
            printer.println(parameterConfiguration.getDescription().toPropertyString(parameterConfiguration.getValue(), commentOut));
        }
    }

    public abstract void mergeProperties(Properties var1);

    public abstract void addParameterConfigurations(ParameterConfiguration ... var1);

    public abstract void removeParameterConfigurations(ParameterConfiguration ... var1);

    public abstract DescriptiveNode getModifiedConfigurationData();

    public String getValueAt(String parameterPath, long date) {
        if (parameterPath == null) {
            return null;
        }
        ParameterPath path = ParameterPath.valueOf(parameterPath);
        return this.getValueAt(path, date);
    }

    public String getValueAt(ParameterPath path, long date) {
        ParameterConfiguration parmConfig = this.fetch(path);
        if (parmConfig == null) {
            SubsystemDescription subsystemDescription = this.getSubsystemDescription();
            ParameterDescription description = subsystemDescription.fetch(path);
            if (description != null) {
                return description.getParameterBase().getDefaultValue();
            }
            DescriptiveNode descriptiveNode = subsystemDescription.getTopComponentNode();
            DescriptiveNode node = (DescriptiveNode)descriptiveNode.getNodeByName(path.componentName);
            if (node == null) {
                return null;
            }
            Map attributes = node.getAttributes();
            Object val = attributes.get(path.parameterName);
            if (val == null) {
                return null;
            }
            if (!(val instanceof HollowParm)) {
                return String.valueOf(val);
            }
            return null;
        }
        if (this.isBeenInEngineeringMode()) {
            List<? extends ValueEvent> eventList = parmConfig.getValueEvents();
            if (eventList == null) {
                return parmConfig.value;
            }
            this.getStartTimestamp();
            this.getEndTimestamp();
            String lastValue = parmConfig.value;
            for (ValueEvent valueEvent : eventList) {
                if (valueEvent.getTime() >= date) {
                    return lastValue;
                }
                lastValue = valueEvent.getValue();
            }
            return lastValue;
        }
        return parmConfig.value;
    }
}

