/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class PluginListHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PluginInfo> getAvailablePlugins(URL url, Logger logger, Studio application) {
        ArrayList<PluginInfo> availablePlugins = new ArrayList<PluginInfo>();
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                Properties prop = application.getAppProperties();
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
                PrintWriter out = new PrintWriter(byteStream, true);
                out.print("app.name=" + this.urlEncode(prop.getProperty("appName")));
                out.print("&app.version=" + this.urlEncode(prop.getProperty("version")));
                out.print("&os.name=" + this.urlEncode(System.getProperty("os.name")));
                out.print("&os.arch=" + this.urlEncode(System.getProperty("os.arch")));
                out.print("&os.version=" + this.urlEncode(System.getProperty("os.version")));
                out.print("&java.version=" + this.urlEncode(System.getProperty("java.version")));
                out.print("&java.vendor=" + this.urlEncode(System.getProperty("java.vendor")));
                out.close();
                String lengthString = String.valueOf(byteStream.size());
                HttpURLConnection http = (HttpURLConnection)connection;
                http.setRequestMethod("POST");
                http.setUseCaches(false);
                http.setDoOutput(true);
                http.setRequestProperty("Content-Length", lengthString);
                http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                byteStream.writeTo(connection.getOutputStream());
            }
            SAXBuilder builder = new SAXBuilder(true);
            builder.setEntityResolver((EntityResolver)new ClassPathEntityResolver("plugin.dtd", Studio.class));
            InputStream in = connection.getInputStream();
            try {
                Document doc = builder.build(in);
                List root = doc.getRootElement().getChildren();
                for (Element node : root) {
                    PluginInfo plugin = new PluginInfo(node);
                    availablePlugins.add(plugin);
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception x) {
            if (logger == null) {
                application.error("Unable to retrieve the list of available plugins", x);
            }
            logger.log(Level.WARNING, "Unable to retrieve the list of available plugins", x);
        }
        availablePlugins.trimToSize();
        return availablePlugins;
    }

    protected String urlEncode(String in) throws UnsupportedEncodingException {
        return URLEncoder.encode(in, "UTF-8");
    }
}

