/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.plugin.jas3.dictionary.AgentListPanel;
import org.lsst.ccs.plugin.jas3.dictionary.ArgInputPanel;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListPanel;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryBusMaster;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreePanel;
import org.lsst.ccs.plugin.jas3.dictionary.HTMLTextPane;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryTreeMainPanel
extends JPanel {
    private CommandListener commandListener;
    private Logger logger = Logger.getLogger((String)"org.lsst.ccs.subsystems.model.dictionaryTreeGui");
    private CommandListPanel cmdList;
    private AgentListPanel agentJList;
    private DictionaryTreePanel dictionaryJTree;
    private ArgInputPanel argInputPanel;
    private HTMLTextPane resultPane;
    private JButton sendCmdButton;
    private JButton refreshAgentsButton;
    private JPanel topPane;
    private SendCommandWorker cmdWorker;
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";

    public DictionaryTreeMainPanel(CommandListener cmdListener) {
        super(new BorderLayout());
        this.commandListener = cmdListener;
        this.agentJList = new AgentListPanel(this.commandListener);
        this.dictionaryJTree = new DictionaryTreePanel(this.commandListener);
        this.agentJList.addListSelectionListener(this.dictionaryJTree);
        JScrollPane agentsView = new JScrollPane(this.agentJList);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.dictionaryJTree.putClientProperty("JTree.lineStyle", lineStyle);
        }
        JScrollPane treeView = new JScrollPane(this.dictionaryJTree);
        this.cmdList = new CommandListPanel();
        this.dictionaryJTree.addTreeSelectionListener(this.cmdList);
        this.agentJList.addListSelectionListener(this.cmdList);
        this.cmdList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DictionaryCommand cmd;
                if (e.getClickCount() == 2 && (cmd = (DictionaryCommand)DictionaryTreeMainPanel.this.cmdList.getSelectedValue()).getArguments().length == 0) {
                    DictionaryTreeMainPanel.this.cmdWorker = new SendCommandWorker(cmd.getCommandName(), new Object[0], "");
                    DictionaryTreeMainPanel.this.cmdWorker.execute();
                }
            }
        });
        JScrollPane cmdListView = new JScrollPane(this.cmdList);
        this.topPane = new JPanel(new GridLayout(1, 3));
        JPanel leftPane = new JPanel(new BorderLayout());
        this.refreshAgentsButton = new JButton("Refresh");
        this.refreshAgentsButton.addActionListener(this.agentJList);
        leftPane.add((Component)agentsView, "Center");
        leftPane.add((Component)this.refreshAgentsButton, "South");
        this.add((Component)leftPane, "West");
        this.topPane.add(treeView);
        this.topPane.add(cmdListView);
        this.argInputPanel = new ArgInputPanel();
        this.cmdList.addListSelectionListener(this.argInputPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.sendCmdButton = new JButton("Send");
        this.sendCmdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String rootNode;
                TreeBranch destinationNode = (TreeBranch)DictionaryTreeMainPanel.this.dictionaryJTree.getLastSelectedPathComponent();
                String destination = destinationNode.toString();
                if (!destination.equals(rootNode = ((TreeBranch)DictionaryTreeMainPanel.this.dictionaryJTree.getModel().getRoot()).toString())) {
                    destination = String.valueOf(rootNode) + "/" + destination;
                }
                String s = "";
                DictionaryCommand cmd = (DictionaryCommand)DictionaryTreeMainPanel.this.cmdList.getSelectedValue();
                if (cmd != null) {
                    int n = cmd.getArguments().length;
                    Object[] p = new Object[n];
                    int i = 0;
                    while (i < n) {
                        p[i] = DictionaryTreeMainPanel.this.parse(DictionaryTreeMainPanel.this.argInputPanel.getArgInput()[i].getText());
                        s = String.valueOf(s) + p[i] + " ";
                        ++i;
                    }
                    DictionaryTreeMainPanel.this.resultPane.insertHTML("invoke " + destination + " " + cmd.getCommandName() + " " + s + "...");
                    DictionaryTreeMainPanel.this.cmdWorker = new SendCommandWorker(cmd.getCommandName(), p, destination);
                    DictionaryTreeMainPanel.this.cmdWorker.execute();
                }
            }
        });
        buttonPane.add(this.sendCmdButton);
        this.add((Component)buttonPane, "South");
        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPaneRightPanel.add((Component)this.argInputPanel, "Center");
        topPaneRightPanel.add((Component)buttonPane, "South");
        this.topPane.add(topPaneRightPanel);
        this.resultPane = new HTMLTextPane();
        JScrollPane resultPaneView = new JScrollPane(this.resultPane);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.topPane);
        splitPane.setBottomComponent(resultPaneView);
        splitPane.setContinuousLayout(true);
        this.add((Component)splitPane, "Center");
    }

    private Object parse(String s) {
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        }
        if (s.matches("-?[0-9]*[.][0-9]*|-?[0-9]*[.][0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        }
        return s;
    }

    private class SendCommandWorker
    extends SwingWorker<String, String> {
        private String cmdName;
        private Object[] cmdArgs;
        private String destination;

        public SendCommandWorker(String cmdName, Object[] cmdArgs, String destination) {
            this.cmdName = cmdName;
            this.cmdArgs = cmdArgs;
            this.destination = destination;
        }

        @Override
        protected String doInBackground() throws Exception {
            return DictionaryTreeMainPanel.this.commandListener.sendCommand(this.cmdName, this.cmdArgs, this.destination);
        }

        @Override
        public void done() {
            try {
                String result = (String)this.get();
                DictionaryTreeMainPanel.this.resultPane.insertHTML(result);
            }
            catch (InterruptedException ex) {
                Logger.getLogger((String)DictionaryBusMaster.class.getName()).log(Level.SEVERE, null, (Throwable)ex, new String[0]);
            }
            catch (ExecutionException ex) {
                Logger.getLogger((String)DictionaryBusMaster.class.getName()).log(Level.SEVERE, null, (Throwable)ex, new String[0]);
            }
        }
    }
}

