/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class CommandListPanel
extends JList<DictionaryCommand>
implements TreeSelectionListener,
ListSelectionListener {
    private SortedListModel cmdListModel = new SortedListModel();

    public CommandListPanel() {
        this.setModel(this.cmdListModel);
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jlist, Object e, int i, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(jlist, e, i, isSelected, cellHasFocus);
                ((JLabel)c).setText(((DictionaryCommand)e).getCommandName());
                return c;
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        TreeBranch node = (TreeBranch)((JTree)tse.getSource()).getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Dictionary d = ((DictionaryContext)node.getContent()).getDictionary();
        this.cmdListModel.clear();
        for (DictionaryCommand dc : d) {
            this.cmdListModel.add(dc);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.cmdListModel.clear();
    }

    private class SortedListModel
    extends AbstractListModel {
        SortedSet<DictionaryCommand> model = new TreeSet<DictionaryCommand>(new Comparator<DictionaryCommand>(){

            @Override
            public int compare(DictionaryCommand o1, DictionaryCommand o2) {
                return o1.getCommandName().compareTo(o2.getCommandName());
            }
        });

        SortedListModel() {
        }

        @Override
        public int getSize() {
            return this.model.size();
        }

        @Override
        public DictionaryCommand getElementAt(int index) {
            return (DictionaryCommand)this.model.toArray()[index];
        }

        public void add(DictionaryCommand element) {
            if (this.model.add(element)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(DictionaryCommand[] elements) {
            List<DictionaryCommand> c = Arrays.asList(elements);
            this.model.addAll(c);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.model.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(DictionaryCommand element) {
            return this.model.contains(element);
        }

        public Object firstElement() {
            return this.model.first();
        }

        public Iterator iterator() {
            return this.model.iterator();
        }

        public Object lastElement() {
            return this.model.last();
        }

        public boolean removeElement(DictionaryCommand element) {
            boolean removed = this.model.remove(element);
            if (removed) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return removed;
        }
    }
}

