package org.lsst.ccs.plugin.jas3.trending;

import hep.aida.IDataPointSet;
import java.util.ArrayList;
import java.util.List;

/**
 * Encapsulates data required to produce a {@link Plot}.
 *
 * @author onoprien
 */
public class PlotData {

// -- Private parts : ----------------------------------------------------------
    
    IDataPointSet value;
    IDataPointSet[] alarmLevels;
    IDataPointSet[] warningLevels;

// -- Construction and initialization : ----------------------------------------
    
    public PlotData(IDataPointSet value) {
        this.value = value;
    }
        
// -- Getters : ----------------------------------------------------------------

    public IDataPointSet getValue() {
        return value;
    }
    
    public List<?> getExtras() {
        ArrayList<IDataPointSet> out = new ArrayList<>(4);
        if (alarmLevels != null) {
            for (IDataPointSet dps : alarmLevels) {
                if (dps != null) out.add(dps);
            }
            for (IDataPointSet dps : warningLevels) {
                if (dps != null) out.add(dps);
            }
        }
        return out;
    }

    public IDataPointSet[] getAlarmLevels() {
        return alarmLevels;
    }

    public IDataPointSet[] getWarningLevels() {
        return alarmLevels;
    }
    
    
// -- Setters : ----------------------------------------------------------------

    public void setAlarmLevels(IDataPointSet[] alarmLevels) {
        this.alarmLevels = alarmLevels;
    }

    public void setWarningLevels(IDataPointSet[] warningLevels) {
        this.warningLevels = warningLevels;
    }

}
