package org.lsst.ccs.plugin.jas3.plots;

import org.lsst.ccs.plugin.jas3.console.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import org.lsst.ccs.utilities.logging.Logger;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.MessagingFactory;
import org.xml.sax.SAXException;

/**
 * This plugin deals with creating LSST CCS plots published on the Status bus.
 * @author turri
 */
public class LsstPlotsPlugin extends Plugin {

    private String defaultConsoleName = "LSST Plots";
    private MessagingFactory messagingFactory;
    private Logger logger = Logger.getLogger("org.lsst.ccs.ui");

    @Override
    protected void init() throws SAXException, IOException {

        Studio studio = getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(this);

    }

    @Override
    protected void postInit() {
        super.postInit();
        messagingFactory = MessagingFactory.getInstance().forSubsystem(BusMessagingLayer.ANONYMOUS_AGENT);
        messagingFactory.addStatusListener(new PlotsListener(getApplication()));
    }
    
   
}
