package org.lsst.ccs.plugin.jas3.dictionary;

import java.io.IOException;
import java.net.URL;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.utilities.logging.Logger;
import org.xml.sax.SAXException;


/**
 *
 * @author F
 */
public class LsstDictionaryPlugin extends Plugin {

    private String defaultConsoleName = "LSST Dictionary";
    DictionaryBusMaster dictionaryBusMaster;
    FreeHEPLookup lookup;
    private Logger logger = Logger.getLogger("org.lsst.ccs.ui");
    private Studio studio;

    @Override
    protected void init() throws SAXException, IOException {

        studio = getApplication();
//        FreeHEPLookup lookup = studio.getLookup();
//        lookup.add(this);

        studio.getCommandTargetManager().add(new LsstDictionaryPlugin.DictionaryCommands());

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstDictionaryPlugin.menus");
        builder.build(xml);
    }
    
     @Override
    protected void postInit() {
        super.postInit();
//        messagingFactory = MessagingFactory.getInstance().forSubsystem(BusMessagingLayer.ANONYMOUS_AGENT);
//        messagingFactory.addStatusListener(new AlarmListener(getApplication()));
    }
    
    private void createDictionaryDialog(String name) {
        dictionaryBusMaster = new DictionaryBusMaster("dictionary-interface");
        dictionaryBusMaster.initGUI();
        studio.getPageManager().openPage(dictionaryBusMaster.getMainPane(), "Dictionary Interface", null);
    }
// This is used to add the Dictionary in the top list of tabs
//    @Override
//    protected void postInit() {
//        super.postInit();
//        dictionaryBusMaster = new DictionaryBusMaster("dictionary-interface");
//        dictionaryBusMaster.initGUI();
//        this.getApplication().getPageManager().openPage(dictionaryBusMaster.getMainPane(), "Dictionary Interface", null);
//        Studio studio = (Studio) Studio.getApplication();
//        lookup = studio.getLookup();
//        lookup.add(this);
//    }
    
  public class DictionaryCommands extends CommandProcessor {

        public void onLsstDictionary() {
            createDictionaryDialog(defaultConsoleName);
        }

    }  

}
