/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryTreePanel extends JTree implements ListSelectionListener {

       private BuildDictionaryWorker dictionaryWorker;
       private CommandListener commandListener;
       private TreeBranch<DictionaryContext> dictionaryTree;


    
    public DictionaryTreePanel(CommandListener cmdListener) {
        super();
        this.setModel(new DefaultTreeModel(dictionaryTree));
        this.commandListener = cmdListener;
        getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        String selectedSubsystem = ((JList<String>)lse.getSource()).getSelectedValue();
        if (selectedSubsystem != null) {
            dictionaryWorker = new BuildDictionaryWorker(selectedSubsystem);
            dictionaryWorker.execute();
        }
    }
    
    private class BuildDictionaryWorker extends SwingWorker<TreeBranch<DictionaryContext>, String> {

        private String destination;

        BuildDictionaryWorker(String destination) {
            this.destination = destination;
        }

        @Override
        protected TreeBranch<DictionaryContext> doInBackground() throws Exception {
            return commandListener.buildDictionaryTree(destination);
        }

        @Override
        public void done() {
            try {
                dictionaryTree = get();
                System.out.println("######## " + dictionaryTree.toString());
                setModel(new DefaultTreeModel(dictionaryTree));
            } catch (InterruptedException | ExecutionException ex) {
                java.util.logging.Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }

}
