/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryTreeMainPanel extends JPanel {

   // private ModelSubsystemBusMaster busMaster;
    private CommandListener commandListener;

    private Logger logger = Logger.getLogger("org.lsst.ccs.subsystems.model.dictionaryTreeGui");
    private CommandListPanel cmdList;

    private AgentListPanel agentJList;

    private DictionaryTreePanel dictionaryJTree;
    private ArgInputPanel argInputPanel;
    private HTMLTextPane resultPane;
    private JButton sendCmdButton;
    private JButton refreshAgentsButton;
    private JPanel topPane;
    private SendCommandWorker cmdWorker;

    //Optionally play with line styles.  Possible values are
    //"Angled" (the default), "Horizontal", and "None".
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";

//    public void initGUI() {
//        //setName("ModelGUIModule");
//        busMaster.setListenToStatus(true);
//        busMaster.setStatusBroadcastPeriod(0);
//        busMaster.start();
//    }
    //Optionally set the look and feel.
    public DictionaryTreeMainPanel(CommandListener cmdListener) {
        super(new BorderLayout());
        commandListener = cmdListener;
     //   busMaster = new ModelSubsystemBusMaster("model-subsystem-gui");

        // Creates the list of subsystems
        agentJList = new AgentListPanel(commandListener);

        // Tree Model
        dictionaryJTree = new DictionaryTreePanel(commandListener);
        agentJList.addListSelectionListener(dictionaryJTree);

        // Create a scroll pane and adds the subsystem list to it
        JScrollPane agentsView = new JScrollPane(agentJList);

        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            dictionaryJTree.putClientProperty("JTree.lineStyle", lineStyle);
        }

        //Create the scroll pane and add the dictionaryJTree to it. 
        JScrollPane treeView = new JScrollPane(dictionaryJTree);

        // Create the command list viewing pane.
        cmdList = new CommandListPanel();
        dictionaryJTree.addTreeSelectionListener(cmdList);
        agentJList.addListSelectionListener(cmdList);

        cmdList.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DictionaryCommand cmd = cmdList.getSelectedValue();
                    // Double click is only enabled for command without arguments
                    if (cmd.getArguments().length == 0) {
                        cmdWorker = new SendCommandWorker(cmd.getCommandName(), new Object[0], "");
                        cmdWorker.execute();
                    }
                }
            }
        });

        JScrollPane cmdListView = new JScrollPane(cmdList);

        //Add the views to the TOP panel
        topPane = new JPanel(new GridLayout(1, 3));

        // Add subsystemview to the main Panel (not the top panel)
        JPanel leftPane = new JPanel(new BorderLayout());
        refreshAgentsButton = new JButton("Refresh");
        refreshAgentsButton.addActionListener(agentJList);

        leftPane.add(agentsView, BorderLayout.CENTER);
        leftPane.add(refreshAgentsButton, BorderLayout.SOUTH);

        //leftPane.setPreferredSize(new Dimension(300, 800));
        add(leftPane, BorderLayout.WEST);

        // Add TreeView to the top panel
        topPane.add(treeView);

        //Add command list view to the top panel
        topPane.add(cmdListView);

        // Result Panel
        // create and add the argInputPanel to the top panel
        argInputPanel = new ArgInputPanel();
        cmdList.addListSelectionListener(argInputPanel);

        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
        sendCmdButton = new JButton("Send");

        sendCmdButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                TreeBranch<DictionaryContext> destinationNode = (TreeBranch<DictionaryContext>) dictionaryJTree.getLastSelectedPathComponent();
                String destination = destinationNode.toString();
                String rootNode = ((TreeBranch<DictionaryContext>) dictionaryJTree.getModel().getRoot()).toString();

                if (!destination.equals(rootNode)) {
                    destination = rootNode + "/" + destination;
                }

                String s = "";
                DictionaryCommand cmd = cmdList.getSelectedValue();
                if (cmd != null) {
                    int n = cmd.getArguments().length;
                    Object[] p = new Object[n];
                    for (int i = 0; i < n; i++) {
                        p[i] = parse(argInputPanel.getArgInput()[i].getText());
                        s += p[i] + " ";
                    }

                    resultPane.insertHTML("invoke " + destination + " " + cmd.getCommandName() + " " + s + "...");
                    cmdWorker = new SendCommandWorker(cmd.getCommandName(), p, destination);


                    cmdWorker.execute();
                }
           //     cmdWorker = new SendCommandWorker("hello", new Object[0], "model-subsystem");
//                    resultPane.insertHTML("invoke " + destination + " " + cmd.getCommandName() + " " + s + "...");

       //             cmdWorker.execute();
            }
        });

        buttonPane.add(sendCmdButton);
        add(buttonPane, BorderLayout.SOUTH);

        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPaneRightPanel.add(argInputPanel, BorderLayout.CENTER);
        topPaneRightPanel.add(buttonPane, BorderLayout.SOUTH);

        topPane.add(topPaneRightPanel);

        // Console Pane
        resultPane = new HTMLTextPane();
        JScrollPane resultPaneView = new JScrollPane(resultPane);

        // Split Panel creation
        JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        splitPane.setTopComponent(topPane);
        splitPane.setBottomComponent(resultPaneView);
        splitPane.setContinuousLayout(true);

        add(splitPane, BorderLayout.CENTER);
    }

    private class SendCommandWorker extends SwingWorker<String, String> {

        private String cmdName;
        private Object[] cmdArgs;
        private String destination;

        public SendCommandWorker(String cmdName, Object[] cmdArgs, String destination) {
            this.cmdName = cmdName;
            this.cmdArgs = cmdArgs;
            this.destination = destination;
        }

        @Override
        protected String doInBackground() throws Exception {
            return commandListener.sendCommand(cmdName, cmdArgs, destination);
        }

        @Override
        public void done() {
            try {
                String result = get();
                resultPane.insertHTML(result);
            } catch (InterruptedException ex) {
                Logger.getLogger(DictionaryBusMaster.class.getName()).log(Level.SEVERE, null, ex);
            } catch (ExecutionException ex) {
                Logger.getLogger(DictionaryBusMaster.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }

    private Object parse(String s) {
        //quoting mechanism
        if (s.startsWith("\"")) {
            // assuming there is a quote at the end .....
            return s.substring(1, s.length() - 1);
        }
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        } else if (s.matches("-?[0-9]*[.][0-9]*|-?[0-9]*[.][0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        } else {
            return s;
        }
    }
}
