/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class CommandListPanel extends JList<DictionaryCommand> implements TreeSelectionListener, ListSelectionListener{
    private SortedListModel cmdListModel;
    
    public CommandListPanel(){
        //super(new SortedListModel());
        cmdListModel= new SortedListModel();
        setModel(cmdListModel);
        
        getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        setCellRenderer(
                new DefaultListCellRenderer() {
                    @Override
                    public Component getListCellRendererComponent(JList<?> jlist, Object e, int i, boolean isSelected, boolean cellHasFocus) {
                        Component c = super.getListCellRendererComponent(jlist, e, i, isSelected, cellHasFocus);
                        ((JLabel) c).setText(((DictionaryCommand) e).getCommandName());
                        return c;
                    }

                });
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        TreeBranch<DictionaryContext> node = (TreeBranch<DictionaryContext>)( ((JTree)tse.getSource()).getLastSelectedPathComponent());
        if (node == null) {
            return;
        }
        Dictionary d = node.getContent().getDictionary();
        // clear the list model and the command description pane
        cmdListModel.clear();

        for (DictionaryCommand dc : d) {
            cmdListModel.add(dc);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        cmdListModel.clear();
    }
    
    private class SortedListModel extends AbstractListModel {
        SortedSet<DictionaryCommand> model;
        
        SortedListModel(){
            model = new TreeSet<DictionaryCommand>(new Comparator<DictionaryCommand>(){
                @Override
                public int compare(DictionaryCommand o1, DictionaryCommand o2) {
                    return o1.getCommandName().compareTo(o2.getCommandName());
                }
            });
        }
        
        @Override
        public int getSize() {
            return model.size();
        }

        @Override
        public DictionaryCommand getElementAt(int index) {
            return (DictionaryCommand)model.toArray()[index];
        }

        public void add(DictionaryCommand element) {
            if (model.add(element)) {
                fireContentsChanged(this, 0, getSize());
            }
        }
        
        public void addAll(DictionaryCommand elements[]) {
            Collection c = Arrays.asList(elements);
            model.addAll(c);
            fireContentsChanged(this, 0, getSize());
        }
        
        public void clear() {
            model.clear();
            fireContentsChanged(this, 0, getSize());
        }
        
        public boolean contains(DictionaryCommand element) {
            return model.contains(element);
        }
        
        public Object firstElement() {
            // Return the appropriate element
            return model.first();
        }

        public Iterator iterator() {
            return model.iterator();
        }

        public Object lastElement() {
            // Return the appropriate element
            return model.last();
        }
        
        public boolean removeElement(DictionaryCommand element) {
            boolean removed = model.remove(element);
            if (removed) {
                fireContentsChanged(this, 0, getSize());
            }
            return removed;   
        }        
        
        
    }
}
