/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IManagedObject;
import hep.aida.IPlottable;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.AnalysisFactory;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.plotter.DummyPlotterFactory;
import hep.aida.ref.tree.Folder;
import hep.aida.ref.tree.MountPoint;
import hep.aida.ref.tree.Tree;
import hep.aida.ref.tree.TreeFactory;
import hep.aida.ref.tuple.FTuple;
import jas.hist.FunctionFactory;
import jas.hist.FunctionRegistry;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.StudioListener;
import org.freehep.jas.event.ScriptEvent;
import org.freehep.jas.extension.aida.AIDAHTMLComponentFactory;
import org.freehep.jas.extension.aida.AIDAPlot;
import org.freehep.jas.extension.aida.AIDAPlotAdapter;
import org.freehep.jas.extension.aida.AIDAPlotter;
import org.freehep.jas.extension.aida.AidaPreferencePanel;
import org.freehep.jas.extension.aida.ITupleFTupleObjectProvider;
import org.freehep.jas.extension.aida.adapter.DataPointSetAdapter;
import org.freehep.jas.extension.aida.adapter.FolderAdapter;
import org.freehep.jas.extension.aida.adapter.FunctionAdapter;
import org.freehep.jas.extension.aida.adapter.HistogramAdapter;
import org.freehep.jas.extension.aida.adapter.ManagedObjectAdapter;
import org.freehep.jas.extension.aida.adapter.MountPointAdapter;
import org.freehep.jas.extension.aida.adapter.PlottableAdapter;
import org.freehep.jas.extension.aida.fitter.FitterFactoryAdapter;
import org.freehep.jas.extension.aida.fitter.JAS3FitterFactory;
import org.freehep.jas.extension.aida.function.ConstantFunctionFactory;
import org.freehep.jas.extension.aida.function.ExponentialFunctionFactory;
import org.freehep.jas.extension.aida.function.GaussianFunctionFactory;
import org.freehep.jas.extension.aida.function.JAS3FunctionFactory;
import org.freehep.jas.extension.aida.function.LineFunctionFactory;
import org.freehep.jas.extension.aida.function.LorentzianFunctionFactory;
import org.freehep.jas.extension.aida.function.MoyalFunctionFactory;
import org.freehep.jas.extension.aida.function.ParabolaFunctionFactory;
import org.freehep.jas.extension.aida.function.SumFunctionFactory;
import org.freehep.jas.plugin.datasource.FileHandlerDataSource;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterProxy;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeMovedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRepaintNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.plugin.tree.utils.linkNode.LinkNode;
import org.freehep.jas.plugin.xmlio.XMLPluginIO;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.Plotter;
import org.freehep.jas.services.PlotterAdapter;
import org.freehep.jas.services.PlotterProvider;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.jas.services.ScriptEngine;
import org.freehep.jas.services.URLHandler;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.util.FreeHEPLookup;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class AIDAPlugin
extends Plugin
implements StudioListener,
FileHandler,
URLHandler,
PlotterProvider,
XMLPluginIO,
PreferencesTopic {
    private static AIDAPlugin thePlugin;
    private IAnalysisFactory factory;
    private Tree aidaMasterTree;
    private Hashtable openFiles = new Hashtable();
    private Hashtable treeNameHash = new Hashtable();
    private PlotFactory plotFactory;
    private String defaultTreeName = "tree";
    private static String[] preferencesPath;
    private Properties userProperties;
    private FTree masterTree;
    private FreeHEPLookup lookup;
    private Studio app;

    public void handleEvent(EventObject event) {
        ScriptEngine engine = ((ScriptEvent)event).getScriptEngine();
        engine.registerVariable("aidaMasterTree", (Object)this.aidaMasterTree);
    }

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("aida", "AIDA File");
    }

    public boolean accept(File file) throws IOException {
        return file.getName().endsWith(".aida");
    }

    public void openFile(File file) throws IOException {
        boolean createNew;
        boolean bl = createNew = !file.exists();
        boolean readOnly = createNew ? false : !file.canWrite();
        this.openFile(file.getAbsolutePath(), "xml", readOnly, createNew, "");
    }

    private void openFile(String fileName, String fileType, boolean readOnly, boolean createNew, String options) throws IOException {
        ITreeFactory tf = this.factory.createTreeFactory();
        Tree tree = (Tree)tf.create(fileName, fileType, readOnly, createNew, options);
    }

    public boolean accept(URL url) throws IOException {
        return url.getFile().endsWith(".aida");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openURL(URL url) throws IOException {
        File temp = File.createTempFile("tmp", "aida");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        InputStream input = url.openStream();
        try {
            int l;
            byte[] buffer = new byte[8096];
            while ((l = input.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, l);
            }
        }
        finally {
            input.close();
            ((OutputStream)out).close();
        }
        int pos = url.getFile().lastIndexOf("/");
        String name = pos > 0 ? url.getFile().substring(pos + 1) : url.getFile();
        this.openFile(temp.getAbsolutePath(), "xml", true, false, "mountpoint=" + name);
    }

    protected void init() throws SAXException, IOException {
        thePlugin = this;
        this.app = this.getApplication();
        this.lookup = this.app.getLookup();
        this.lookup.add((Object)this);
        this.lookup.add((Object)new FileHandlerDataSource((FileHandler)this));
    }

    protected void postInit() {
        System.setProperty("hep.aida.IAnalysisFactory", JASAnalysisFactory.class.getName());
        this.factory = new JASAnalysisFactory();
        this.lookup.add((Object)this.factory);
        AIDAHTMLComponentFactory htmlFactory = new AIDAHTMLComponentFactory();
        htmlFactory.init(this.app);
        this.aidaMasterTree = (Tree)this.factory.createTreeFactory().create();
        this.lookup.add((Object)this.aidaMasterTree);
        FTreeProvider treeProvider = (FTreeProvider)this.getApplication().getLookup().lookup(FTreeProvider.class);
        this.masterTree = treeProvider.tree();
        FTreeAIDAListenerAdapter materTreeAidaAdapter = new FTreeAIDAListenerAdapter(this.masterTree, this.aidaMasterTree);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new ManagedObjectAdapter(this, this.app), IManagedObject.class);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new HistogramAdapter(this, this.app), IBaseHistogram.class);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new FunctionAdapter(this, this.app), IFunction.class);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new DataPointSetAdapter(this, this.app), IDataPointSet.class);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new MountPointAdapter(this, this.app), MountPoint.class);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new PlottableAdapter(this, this.app), IPlottable.class);
        FolderAdapter folderAdapter = new FolderAdapter(this, this.app);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)folderAdapter, Folder.class);
        this.lookup.add((Object)folderAdapter);
        treeProvider.treeNodeAdapterRegistry().registerNodeObjectProvider((FTreeNodeObjectProvider)new ITupleFTupleObjectProvider(), ITuple.class, 150);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new DefaultFTreeNodeAdapterProxy(FTuple.class), ITuple.class);
        this.app.getEventSender().addEventListener((StudioListener)this, ScriptEvent.class);
        this.plotFactory = (PlotFactory)this.getApplication().getLookup().lookup(PlotFactory.class);
        AIDAPlotAdapter adapter = new AIDAPlotAdapter(this, this.app);
        this.plotFactory.registerAdapter((PlotterAdapter)adapter, IBaseHistogram.class, JAS3DataSource.class);
        this.plotFactory.registerAdapter((PlotterAdapter)adapter, IFunction.class, JAS3DataSource.class);
        this.plotFactory.registerAdapter((PlotterAdapter)adapter, IDataPointSet.class, JAS3DataSource.class);
        this.app.getLookup().add((Object)new AIDAPlotFactory(this));
        this.userProperties = this.app.getUserProperties();
        FunctionRegistry.instance().registerFunction((FunctionFactory)new GaussianFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new ExponentialFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new ConstantFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new LineFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new ParabolaFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new MoyalFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new LorentzianFunctionFactory());
        FunctionRegistry.instance().registerFunction((FunctionFactory)new SumFunctionFactory());
        FitterFactoryAdapter.registerFitters((Lookup)this.getApplication().getLookup());
    }

    public Tree aidaMasterTree() {
        return this.aidaMasterTree;
    }

    public Object findInTree(FTreePath path, Class clazz) {
        Object obj = this.masterTree.findNode(path).objectForClass(clazz);
        return obj;
    }

    public FTree tree() {
        return this.masterTree;
    }

    private IPlotterFactory createPlotterFactory() {
        return new JASPlotterFactory();
    }

    private ITreeFactory createTreeFactory(IAnalysisFactory analysisFactory) {
        return new JAS3TreeFactory(analysisFactory);
    }

    public String getMountPointName(String name) {
        if (name == null) {
            name = this.defaultTreeName;
        }
        int index = 0;
        String tmpName = "/" + name;
        String[] names = this.aidaMasterTree.listObjectNames("/");
        String[] types = this.aidaMasterTree.listObjectTypes("/");
        for (int i = 0; i < names.length; ++i) {
            if (!types[i].equals("mnt")) continue;
            names[i] = names[i].substring(0, names[i].length() - 1);
            if (!names[i].startsWith(tmpName)) continue;
            int nameIndex = 0;
            if (names[i].equals(tmpName)) {
                nameIndex = 1;
            } else {
                try {
                    nameIndex = Integer.parseInt(names[i].substring(tmpName.length() + 1)) + 1;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (nameIndex <= index) continue;
            index = nameIndex;
        }
        if (index != 0 || name.equals(this.defaultTreeName)) {
            name = name + "-" + index;
        }
        return name;
    }

    public FTreePath pathForManagedObject(IManagedObject obj) {
        try {
            String path = this.aidaMasterTree.findPath(obj);
            return new FTreePath(path);
        }
        catch (IllegalArgumentException iae) {
            if (obj.name() != null) {
                return new FTreePath(obj.name());
            }
            return new FTreePath("");
        }
    }

    public void checkForChildrenForNode(FTreePath path) {
        this.aidaMasterTree.checkForChildren(this.fullPath(path));
    }

    public String fullPath(FTreePath path) {
        String pathName = "";
        int nNodes = path.getPathCount();
        for (int i = 0; i < nNodes - 1; ++i) {
            pathName = pathName + "/" + path.getPathComponent(i);
        }
        pathName = pathName + "/" + AidaUtils.modifyName((String)path.getLastPathComponent());
        return pathName;
    }

    public Plotter create() {
        return new AIDAPlot(this.plotFactory, this, this.getApplication());
    }

    public boolean supports(Class klass) {
        return IBaseHistogram.class.isAssignableFrom(klass) || IDataPointSet.class.isAssignableFrom(klass) || IFunction.class.isAssignableFrom(klass);
    }

    public int restore(int level, XMLIOManager manager, Element el) {
        switch (level) {
            case 0: {
                if (el == null) {
                    return -1;
                }
                List files = el.getChildren("file");
                if (files == null) {
                    return -1;
                }
                for (int i = 0; i < files.size(); ++i) {
                    Element fileEl = (Element)files.get(i);
                    String fileName = fileEl.getAttributeValue("name");
                    String fileType = fileEl.getAttributeValue("type");
                    String options = "mountpoint=" + fileEl.getAttributeValue("mountpoint");
                    String treeOptions = fileEl.getAttributeValue("options");
                    if (treeOptions != null && !treeOptions.trim().equals("")) {
                        options = options + ", " + treeOptions;
                    }
                    try {
                        this.openFile(fileName, fileType, true, false, options);
                        continue;
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog((Component)this.getApplication(), "Could not restore file: " + fileName, "Error", 0);
                    }
                }
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal level " + level + ". Please report this problem");
    }

    public void save(XMLIOManager manager, Element el) {
        Enumeration trees = this.treeNameHash.keys();
        while (trees.hasMoreElements()) {
            String mountPoint = (String)trees.nextElement();
            try {
                this.aidaMasterTree.listObjectNames("/" + mountPoint);
                String fileName = (String)this.treeNameHash.get(mountPoint);
                if (fileName == null) continue;
                Element fileEl = new Element("file");
                fileEl.setAttribute("name", fileName);
                String fileType = (String)this.openFiles.get(fileName);
                if (fileType != null) {
                    fileEl.setAttribute("type", fileType);
                }
                fileEl.setAttribute("mountpoint", mountPoint);
                try {
                    ITree t = this.aidaMasterTree.findTree("/" + mountPoint);
                    Map optMap = ((Tree)t).getOptions();
                    if (optMap != null && optMap.size() > 0) {
                        String options = AidaUtils.createOptionsString((Map)optMap);
                        fileEl.setAttribute("options", options);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                el.addContent((Content)fileEl);
            }
            catch (IllegalArgumentException iae) {}
        }
    }

    public boolean apply(JComponent panel) {
        return ((AidaPreferencePanel)panel).apply();
    }

    public JComponent component() {
        return new AidaPreferencePanel(this);
    }

    public String[] path() {
        return preferencesPath;
    }

    public boolean isShowNamesAndTitles() {
        return PropertyUtilities.getBoolean((Properties)this.getApplication().getUserProperties(), (String)"AIDA.ShowNamesAndTitles", (boolean)true);
    }

    void setShowNamesAndTitles(boolean showNamesAndTitles) {
        PropertyUtilities.setBoolean((Properties)this.getApplication().getUserProperties(), (String)"AIDA.ShowNamesAndTitles", (boolean)showNamesAndTitles);
        this.masterTree.treeChanged((FTreeNotification)new FTreeNodeRepaintNotification((Object)this, this.masterTree.root().path(), true));
    }

    public File getLastDir() {
        String file = this.userProperties.getProperty("aidaPlugin.lastDir", "{user.home}");
        return new File(file);
    }

    public void setLastDir(File dir) {
        this.userProperties.setProperty("aidaPlugin.lastDir", dir.getAbsolutePath());
    }

    static {
        preferencesPath = new String[]{"AIDA", "General"};
    }

    private class AIDAPlotFactory
    implements XMLIOFactory {
        private AIDAPlugin thePlugin;
        private Class[] classes = new Class[]{AIDAPlot.class};

        AIDAPlotFactory(AIDAPlugin thePlugin) {
            this.thePlugin = thePlugin;
        }

        public Class[] XMLIOFactoryClasses() {
            return this.classes;
        }

        public Object createObject(Class objClass) throws IllegalArgumentException {
            if (objClass == AIDAPlot.class) {
                return this.thePlugin.create();
            }
            throw new IllegalArgumentException("Cannot create class " + objClass);
        }
    }

    private class AidaLink
    implements LinkNode {
        private FTreePath path;
        private FTree tree;

        AidaLink(FTreePath path, FTree tree) {
            this.tree = tree;
            this.path = path;
        }

        public FTreePath linkedPath() {
            return this.path;
        }

        public FTree tree() {
            return this.tree;
        }
    }

    private class FTreeAIDAListenerAdapter2
    implements AIDAListener {
        private FTree masterTree;
        private FTreePath mountPath;
        private Tree tree;
        private HashMap map = new HashMap();

        public FTreeAIDAListenerAdapter2(FTree masterTree, Tree tree, FTreePath mountPath) {
            this.masterTree = masterTree;
            this.tree = tree;
            this.mountPath = mountPath;
            tree.checkForChildren("/");
            tree.addListener((AIDAListener)this);
        }

        public void stateChanged(EventObject evt) {
            TreeEvent e = (TreeEvent)evt;
            int id = e.getID();
            Class clazz = e.getType();
            String[] eventPath = e.getPath();
            FTreePath fullPath = this.mountPath.pathByAddingPath(eventPath);
            if (eventPath.length > 0) {
                String tmp;
                eventPath[eventPath.length - 1] = tmp = AidaUtils.parseName((String)eventPath[eventPath.length - 1]);
            }
            if (id == 1) {
                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this, fullPath, clazz));
            } else if (id == 6) {
                FTreePath linkPath = this.mountPath.pathByAddingPath(e.getLinkPath());
                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this, fullPath, (Object)new AidaLink(linkPath, this.masterTree)));
            } else if (id == 2) {
                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)this, fullPath));
            }
            if (id == 7) {
                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeMovedNotification((Object)this, this.mountPath.pathByAddingPath(e.getOldPath()), this.mountPath.pathByAddingPath(e.getPath())));
            } else if (id != 4) {
                if (id == 5) {
                    this.masterTree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)this, fullPath));
                }
            }
        }
    }

    private class FTreeAIDAListenerAdapter
    implements AIDAListener {
        private FTree masterTree;
        private FTreePath currentPath;
        private Tree tree;
        private HashMap map = new HashMap();

        public FTreeAIDAListenerAdapter(FTree masterTree, Tree tree) {
            this.masterTree = masterTree;
            this.tree = tree;
            tree.checkForChildren("/");
            tree.addListener((AIDAListener)this);
        }

        private String fullName(String[] path) {
            if (path.length > 0) {
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < path.length; ++i) {
                    b.append('/');
                    b.append(path[i]);
                }
                return b.toString();
            }
            return "/";
        }

        private String parentFullName(String[] path) {
            if (path.length == 0) {
                return "/";
            }
            String[] newPath = new String[path.length - 1];
            System.arraycopy(path, 0, newPath, 0, newPath.length);
            return this.fullName(newPath);
        }

        public void stateChanged(EventObject evt) {
            block10: {
                TreeEvent e;
                block12: {
                    int id;
                    block11: {
                        block9: {
                            e = (TreeEvent)evt;
                            id = e.getID();
                            Class clazz = e.getType();
                            String[] eventPath = e.getPath();
                            if (eventPath.length > 0) {
                                String tmp;
                                eventPath[eventPath.length - 1] = tmp = AidaUtils.parseName((String)eventPath[eventPath.length - 1]);
                            }
                            if (id == 1) {
                                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this, new FTreePath(e.getPath()), clazz));
                            } else if (id == 6) {
                                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this, new FTreePath(e.getPath()), (Object)new AidaLink(new FTreePath(e.getLinkPath()), this.masterTree)));
                            } else if (id == 2) {
                                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)this, new FTreePath(e.getPath())));
                            }
                            if (id != 7) break block9;
                            this.masterTree.treeChanged((FTreeNotification)new FTreeNodeMovedNotification((Object)this, new FTreePath(e.getOldPath()), new FTreePath(e.getPath())));
                            break block10;
                        }
                        if (id == 4) break block10;
                        if (id != 5) break block11;
                        AIDAPlugin.this.aidaMasterTree.unmount(new FTreePath(e.getPath()).toString());
                        break block10;
                    }
                    if (id == 11) break block12;
                    if (id != 12) break block10;
                }
                this.masterTree.treeChanged((FTreeNotification)new FTreeNodeRepaintNotification((Object)this, new FTreePath(e.getPath()), true));
            }
        }
    }

    private class JASPlotterFactory
    extends DummyPlotterFactory {
        private JASPlotterFactory() {
        }

        public IPlotter create() {
            return this.create("Plotter");
        }

        public IPlotter create(String title) {
            PlotPage page = AIDAPlugin.this.plotFactory.createPage(title);
            return new AIDAPlotter(AIDAPlugin.this.plotFactory, page);
        }
    }

    private class JAS3TreeFactory
    extends TreeFactory {
        private IAnalysisFactory analysisFactory;

        public JAS3TreeFactory(IAnalysisFactory analysisFactory) {
            super(analysisFactory);
            this.analysisFactory = analysisFactory;
        }

        public ITree createNamedTree(String name, String storeName, String storeType, int mode, String options) throws IllegalArgumentException, IOException {
            Tree tree = (Tree)super.createNamedTree(name, storeName, storeType, mode, options);
            this.initTree(tree);
            return tree;
        }

        protected ITree createTree(String storeName, String storeType, boolean readOnly, boolean createNew, String options, boolean readOnlyUserDefined) throws IllegalArgumentException, IOException {
            Tree tree = (Tree)super.createTree(storeName, storeType, readOnly, createNew, options, readOnlyUserDefined);
            this.initTree(tree);
            return tree;
        }

        private void initTree(Tree tree) {
            if (tree.storeName() == null) {
                this.mountInMasterTree(null, (ITree)tree);
            } else {
                Map optionsMap = tree.getOptions();
                if (optionsMap != null) {
                    String autoMount = (String)optionsMap.get("automount");
                    String mountInFTree = (String)optionsMap.get("mountinftree");
                    if (autoMount == null || autoMount.equalsIgnoreCase("true")) {
                        String mountPoint = (String)optionsMap.get("mountpoint");
                        if (mountInFTree == null || mountInFTree.equalsIgnoreCase("false")) {
                            this.mountInMasterTree(mountPoint, (ITree)tree);
                        } else {
                            this.mountInFTree(mountPoint, tree);
                        }
                    }
                    if (tree.storeType() != null) {
                        AIDAPlugin.this.openFiles.put(tree.storeName(), tree.storeType());
                    }
                }
            }
        }

        private void mountInFTree(String mountPoint, Tree tree) {
            String storeName;
            String name = mountPoint;
            if (name == null && (storeName = tree.storeName()) != null) {
                int pos = storeName.lastIndexOf(File.separatorChar, storeName.length() - 1);
                if (pos >= 0) {
                    storeName = storeName.substring(pos + 1);
                }
                if ((pos = storeName.lastIndexOf("/", storeName.length() - 1)) >= 0) {
                    storeName = storeName.substring(pos + 1);
                }
                name = storeName;
            }
            FTreePath fTreePath = new FTreePath(name);
            AIDAPlugin.this.masterTree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)AIDAPlugin.this.getApplication(), fTreePath, (Object)tree));
            FTreeAIDAListenerAdapter2 materTreeAidaAdapter = new FTreeAIDAListenerAdapter2(AIDAPlugin.this.masterTree, tree, fTreePath);
        }

        private void mountInMasterTree(String mountPoint, ITree tree) {
            if (AIDAPlugin.this.aidaMasterTree != null) {
                String storeName;
                String name = mountPoint;
                if (name == null && (storeName = tree.storeName()) != null) {
                    int pos = storeName.lastIndexOf(File.separatorChar, storeName.length() - 1);
                    if (pos >= 0) {
                        storeName = storeName.substring(pos + 1);
                    }
                    if ((pos = storeName.lastIndexOf("/", storeName.length() - 1)) >= 0) {
                        storeName = storeName.substring(pos + 1);
                    }
                    name = storeName;
                }
                name = AIDAPlugin.this.getMountPointName(name);
                AIDAPlugin.this.aidaMasterTree.mount("/" + name, tree, "/");
                storeName = tree.storeName();
                if (storeName != null) {
                    AIDAPlugin.this.treeNameHash.put(name, storeName);
                }
            }
        }
    }

    public static class JASAnalysisFactory
    extends AnalysisFactory {
        private ITreeFactory treeFactory = null;

        public IPlotterFactory createPlotterFactory() {
            return thePlugin.createPlotterFactory();
        }

        public ITreeFactory createTreeFactory() {
            if (this.treeFactory == null) {
                this.treeFactory = thePlugin.createTreeFactory((IAnalysisFactory)this);
            }
            return this.treeFactory;
        }

        public IFunctionFactory createFunctionFactory(ITree tree) {
            return new JAS3FunctionFactory(tree);
        }

        public IFitFactory createFitFactory() {
            return new JAS3FitterFactory();
        }
    }
}

