/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.jas.plugin.plotter.DefaultPlotRegionDropHandler;
import org.freehep.jas.plugin.plotter.RegionBorder;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;

class DefaultRegion
extends JPanel
implements PlotRegion,
DropTargetListener,
HasPopupItems,
ActionListener {
    private RegionBorder border = new RegionBorder();
    private Color activeBorderColor = Color.red;
    private Color defaultBorderColor = Color.green;
    private Color selectedBorderColor = Color.blue;
    private PlotFactory factory;
    private Plotter plotter;
    private PlotRegionDropHandler defaultDropHandler;
    private boolean selected = false;

    DefaultRegion(PlotFactory factory) {
        super(new BorderLayout());
        this.factory = factory;
        this.setBorder(this.border);
        this.border.setColor(this.defaultBorderColor);
        this.defaultDropHandler = new DefaultPlotRegionDropHandler(this, factory);
        this.setOpaque(false);
        DropTarget dt = new DropTarget(this, this);
    }

    void setSelected(boolean selected) {
        this.selected = selected;
        this.border.setColor(selected ? this.selectedBorderColor : this.defaultBorderColor);
        this.repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.acceptOrReject(dtde)) {
            this.border.setColor(this.activeBorderColor);
            this.repaint();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.border.setColor(this.selected ? this.selectedBorderColor : this.defaultBorderColor);
        this.repaint();
    }

    boolean acceptOrReject(DropTargetDragEvent e) {
        boolean accept = false;
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            Class<?> k = flavors[i].getRepresentationClass();
            boolean bl = accept = Plotter.class.isAssignableFrom(k) || this.factory.canCreatePlotterFor(k);
            if (accept) break;
        }
        if (accept) {
            e.acceptDrag(0x40000000);
        } else {
            e.rejectDrag();
        }
        return accept;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.border.setColor(this.defaultBorderColor);
        this.repaint();
        this.factory.currentPage().setCurrentRegion(this);
        try {
            PlotRegionDropHandler dh = this.getPlotRegionDropHandler(dtde);
            if (dh == null) {
                this.defaultDropHandler.drop(dtde);
            } else {
                dh.setPlotRegion(this);
                dh.drop(dtde);
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            dtde.dropComplete(false);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public PlotRegionDropHandler getPlotRegionDropHandler(DropTargetDropEvent dtde) {
        PlotRegionDropHandler dh = null;
        try {
            Transferable t = dtde.getTransferable();
            DataFlavor[] flavors = t.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                Class<?> k = flavors[i].getRepresentationClass();
                if (!PlotRegionDropHandler.class.isAssignableFrom(k)) continue;
                dh = (PlotRegionDropHandler)t.getTransferData(flavors[i]);
                break;
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            dtde.dropComplete(false);
        }
        return dh;
    }

    @Override
    public void showPlot(Plotter plotter) {
        this.removeAll();
        this.plotter = plotter;
        this.add(plotter.viewable(), "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void clear() {
        if (this.plotter != null) {
            this.plotter.clear();
            this.plotter = null;
        }
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    @Override
    public Plotter currentPlot() {
        return this.plotter;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("clear")) {
            this.clear();
        }
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JMenuItem item = new JMenuItem("Clear Region");
        item.setActionCommand("clear");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    @Override
    protected void printBorder(Graphics g) {
    }
}

