/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import com.sun.jersey.api.client.WebResource;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.ref.histogram.DataPointSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.plugin.jas3.trending.DataChannelTreeAdapter;
import org.lsst.ccs.plugin.jas3.trending.Plot;
import org.lsst.ccs.plugin.jas3.trending.PlotData;
import org.lsst.ccs.plugin.jas3.trending.TrendingPreferences;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeWindow;

public class DataChannelHandler {
    private final DataChannel channel;
    private final DataChannelTreeAdapter adapter;
    private ArrayList<WeakReference<Plot>> plots;

    DataChannelHandler(DataChannel dataChannel, DataChannelTreeAdapter treeAdapter) {
        this.channel = dataChannel;
        this.adapter = treeAdapter;
    }

    public String getPath() {
        return this.channel.getPathAsString();
    }

    public DataChannel getDataChannel() {
        return this.channel;
    }

    public synchronized List<Plot> getPlotDataAll() {
        if (this.plots == null) {
            return Collections.emptyList();
        }
        System.gc();
        boolean purge = false;
        ArrayList<Plot> out = new ArrayList<Plot>(this.plots.size());
        ListIterator<WeakReference<Plot>> it = this.plots.listIterator();
        while (it.hasNext()) {
            WeakReference<Plot> ref = it.next();
            Plot pd = (Plot)ref.get();
            if (pd == null || !this.isDataPlotted(pd)) {
                it.remove();
                purge = true;
                continue;
            }
            out.add(pd);
        }
        if (out.isEmpty()) {
            this.plots = null;
        }
        if (purge) {
            this.purge();
        }
        return out;
    }

    public Plot findPlotData(TimeWindow timeWindow) {
        if (this.plots == null) {
            return null;
        }
        Plot out = null;
        for (Plot pd : this.getPlotDataAll()) {
            if (pd.getRegion().currentPlot().getData().size() != 1) continue;
            if (pd.getTimeWindow() == timeWindow) {
                return pd;
            }
            if (out != null && pd.getPage().numberOfRegions() >= out.getPage().numberOfRegions()) continue;
            out = pd;
        }
        return out;
    }

    public Plot makePlotData(TimeWindow timeWindow) {
        long begin = timeWindow.getLowerEdge();
        long end = timeWindow.getUpperEdge();
        PlotData dps = this.makeDataPointSet(begin, end);
        Plot pd = new Plot(dps, timeWindow, this);
        pd.setTimeRange(begin, end);
        return pd;
    }

    public boolean refresh(Plot plot) {
        TimeWindow timeWindow = plot.getTimeWindow();
        if (timeWindow.isFixed()) {
            return false;
        }
        long begin = timeWindow.getLowerEdge();
        long end = timeWindow.getUpperEdge();
        plot.prepareRefresh(this.makeDataPointSet(begin, end), begin, end);
        return true;
    }

    public synchronized boolean addPlotData(Plot plot) {
        boolean out = true;
        if (this.plots == null) {
            this.plots = new ArrayList(1);
        } else {
            boolean purge = false;
            ListIterator<WeakReference<Plot>> it = this.plots.listIterator();
            while (it.hasNext()) {
                WeakReference<Plot> ref = it.next();
                Plot pd = (Plot)ref.get();
                if (pd == null) {
                    it.remove();
                    purge = true;
                    continue;
                }
                if (pd != plot) continue;
                out = false;
            }
            if (purge) {
                this.purge();
            }
        }
        if (out) {
            this.plots.add(new WeakReference<Plot>(plot));
        }
        return out;
    }

    public synchronized boolean removePlotData(Plot plot) {
        if (this.plots == null) {
            return false;
        }
        boolean out = false;
        boolean purge = false;
        ListIterator<WeakReference<Plot>> it = this.plots.listIterator();
        while (it.hasNext()) {
            WeakReference<Plot> ref = it.next();
            Plot pd = (Plot)ref.get();
            if (pd == null) {
                it.remove();
                purge = true;
                continue;
            }
            if (pd != plot) continue;
            it.remove();
            out = true;
        }
        if (out || purge) {
            this.purge();
        }
        if (this.plots.isEmpty()) {
            this.plots = null;
        }
        return out;
    }

    private PlotData makeDataPointSet(long begin, long end) {
        WebResource resource = this.adapter.getResource().path("data").path(String.valueOf(this.channel.getId()));
        resource = resource.queryParam("t1", String.valueOf(begin)).queryParam("t2", String.valueOf(end));
        TrendingPreferences pref = this.adapter.getPlugin().getPreferences();
        int nBins = pref.nBins();
        if (nBins > 0) {
            if (!pref.useRawData()) {
                resource = resource.queryParam("flavor", "stat");
            }
            resource = resource.queryParam("n", Integer.toString(nBins));
        } else {
            resource = resource.queryParam("flavor", pref.useRawData() ? "raw" : "stat");
        }
        Data data = (Data)resource.accept(new String[]{"text/xml"}).get(Data.class);
        TrendingResult result = data.getTrendingResult();
        DataPointSet dps = new DataPointSet("", "", 2);
        TrendingData[] dataArray = result.getTrendingDataArray();
        if (dataArray != null) {
            TrendingData[] trendingDataArray = dataArray;
            int n = dataArray.length;
            int n2 = 0;
            while (n2 < n) {
                TrendingData d = trendingDataArray[n2];
                IDataPoint p = dps.addPoint();
                p.coordinate(0).setValue((double)d.getAxisvalue().getValue() / 1000.0);
                p.coordinate(1).setValue(d.getValue("value"));
                ++n2;
            }
        }
        PlotData pd = new PlotData((IDataPointSet)dps);
        List metaList = result.getChannelMetadata();
        HashMap<String, DataPointSet> metaMap = new HashMap<String, DataPointSet>();
        for (ChannelMetaData meta : metaList) {
            try {
                dps = (DataPointSet)metaMap.get(meta.getName());
                if (dps == null) {
                    dps = new DataPointSet("", "", 2);
                    metaMap.put(meta.getName(), dps);
                }
                double value = Double.parseDouble(meta.getValue());
                long start = meta.getTstart();
                if (start < begin) {
                    start = begin;
                }
                IDataPoint p = dps.addPoint();
                p.coordinate(0).setValue((double)start / 1000.0);
                p.coordinate(1).setValue(value);
                long stop = meta.getTstop();
                if (stop > end || stop == -1L) {
                    stop = end;
                }
                p = dps.addPoint();
                p.coordinate(0).setValue((double)stop / 1000.0);
                p.coordinate(1).setValue(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        DataPointSet alarmLow = (DataPointSet)metaMap.get("alarmLow");
        DataPointSet alarmHigh = (DataPointSet)metaMap.get("alarmHigh");
        if (alarmLow != null || alarmHigh != null) {
            pd.setAlarmLevels(new IDataPointSet[]{alarmLow, alarmHigh});
        }
        DataPointSet warningLow = (DataPointSet)metaMap.get("warningLow");
        DataPointSet warningHigh = (DataPointSet)metaMap.get("warningHigh");
        if (warningLow != null || warningHigh != null) {
            pd.setAlarmLevels(new IDataPointSet[]{warningLow, warningHigh});
        }
        return pd;
    }

    private boolean isDataPlotted(Plot plotData) {
        PlotPage page = plotData.getPage();
        PlotRegion region = plotData.getRegion();
        if (page == null || region == null) {
            return false;
        }
        Plotter p = region.currentPlot();
        if (p == null) {
            return false;
        }
        List dataList = p.getData();
        if (dataList == null || dataList.indexOf(plotData) == -1) {
            return false;
        }
        int n = page.numberOfRegions();
        int i = 0;
        while (i < n) {
            PlotRegion r = page.region(i);
            if (r == region) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void purge() {
    }
}

