/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreeMainPanel;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryTreePanel
extends JTree
implements ListSelectionListener {
    private BuildDictionaryWorker dictionaryWorker;
    private CommandListener commandListener;
    private TreeBranch<DictionaryContext> dictionaryTree;

    public DictionaryTreePanel(CommandListener cmdListener) {
        this.setModel(new DefaultTreeModel((TreeNode)this.dictionaryTree));
        this.commandListener = cmdListener;
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        String selectedSubsystem = (String)((JList)lse.getSource()).getSelectedValue();
        if (selectedSubsystem != null) {
            this.dictionaryWorker = new BuildDictionaryWorker(selectedSubsystem);
            this.dictionaryWorker.execute();
        }
    }

    private class BuildDictionaryWorker
    extends SwingWorker<TreeBranch<DictionaryContext>, String> {
        private String destination;

        public BuildDictionaryWorker(String destination) {
            this.destination = destination;
        }

        @Override
        protected TreeBranch<DictionaryContext> doInBackground() throws Exception {
            return DictionaryTreePanel.this.commandListener.buildDictionaryTree(this.destination);
        }

        @Override
        public void done() {
            try {
                DictionaryTreePanel.this.dictionaryTree = (TreeBranch)this.get();
                DictionaryTreePanel.this.setModel(new DefaultTreeModel((TreeNode)DictionaryTreePanel.this.dictionaryTree));
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

