/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.framework.CommandPresenceAgent;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryBusMaster extends BusMaster {

    private SynchronousCommandAgent syncAgent;
    private CommandPresenceAgent cpa;
    private DictionaryTreeMainPanel mainPanel;
        private static boolean useSystemLookAndFeel = true;


    public DictionaryBusMaster(String name) {
        super();
        this.setName(name); // this also instanciates the messaging factory
        this.syncAgent = new SynchronousCommandAgent(this.fac);
        this.setStatusBroadcastPeriod(0);
        
        // Command Presence Agent initialization
        cpa = new CommandPresenceAgent(fac);

        mainPanel = new DictionaryTreeMainPanel(new CommandListener() {

            @Override
            public String sendCommand(String cmdName, Object[] cmdArgs, String destination) {
                return executeSyncInvoke(cmdName, cmdArgs, destination);
            }

            @Override
            public List<String> getConnectedAgents() {
                return busMasterGetConnectedAgents();
            }

            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return busMasterBuildDictionaryTree(destination);
            }
        });
    }
    
    public DictionaryTreeMainPanel getMainPane(){
        return mainPanel;
    }

    public void initGUI() {
        //setName("ModelGUIModule");
        setListenToStatus(true);
        setStatusBroadcastPeriod(0);
        start();
    }


    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }

//    private static void createAndShowGUI() {
//        // Main window
//        DictionaryBusMaster subsystem = new DictionaryBusMaster("command dictionary interface");
//
//        JFrame frame = new JFrame("Dictionary Interface");
//        frame.setJMenuBar(subsystem.createMenuBar());
//        frame.add(subsystem.getMainPane());
//        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//        frame.setVisible(true);
//        frame.setMinimumSize(new Dimension(800, 800));
//        frame.pack();
//        subsystem.initGUI();
//    }
 //   public static void main(String[] args) {
        
    /*      System.setProperty("java.naming.factory.initial",
                "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs",
                "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state",
                "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost",
                args.length >= 1 ? args[0] : "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");

        // Look and Feel handling
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } catch (Exception e) {
                System.err.println("Couldn't use system look and feel");
            }
        }

        EventQueue.invokeLater(new Runnable() {

            @Override
            public void run() {
            //    createAndShowGUI();
            }
        });*/
  //  }
    public List<String> busMasterGetConnectedAgents() {
        return cpa.listAll();
    }
    
    public TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {

        long timeout = Long.parseLong("5000");
        TreeBranch<DictionaryContext> dictionaryTree = null;
        // Root Node building
        ModuleInvokerCommand cmdGetSystemDictionary = new ModuleInvokerCommand("getSystemDictionary", new Object[0]);
        cmdGetSystemDictionary.setDestination(destination);
        cmdGetSystemDictionary.setCanRunInActiveMode(false);
        try {
            Object res = syncAgent.invoke(cmdGetSystemDictionary, timeout);
            // in fact if this is an exception should mark as error!
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Exception) res, 1);
                message("error?: " + strRes, true);
            } else if (res == null) {
                strRes = "ok : VOID";
                message(strRes, false);
            } else {
                strRes = String.valueOf(res);
                message("result: " + strRes, false);

                Dictionary systemDictionary = (Dictionary) res;
                dictionaryTree = new TreeBranch<DictionaryContext>(new DictionaryContext(destination, systemDictionary));
            }
        } catch (Exception e) {
            message(" Exception caught :" + StackTraceFormats.toString(e, 1), true);
        }

        // Dictionary Tree Building
        ModuleInvokerCommand cmdGetComponentDictionariesTree = new ModuleInvokerCommand("getComponentDictionariesTree", new Object[0]);
        cmdGetComponentDictionariesTree.setDestination(destination);
        //TODO: if command halt force!
        cmdGetComponentDictionariesTree.setCanRunInActiveMode(false);
        try {
            Object res = syncAgent.invoke(cmdGetComponentDictionariesTree, timeout);
            // in fact if this is an exception should mark as error!
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Exception) res, 1);
                message("error?: " + strRes, true);
            } else if (res == null) {
                strRes = "ok : VOID";
                message(strRes, false);
            } else {
                strRes = String.valueOf(res);
                message("result: " + strRes, false);
                dictionaryTree.addChild((TreeBranch<DictionaryContext>) res);
                return dictionaryTree;// Copy of the command result in dictionaryString
            }
        } catch (Exception e) {
            message(" Exception caught :" + StackTraceFormats.toString(e, 1), true);
        }
        return null;
    }

    public String executeSyncInvoke(String cmdName, Object[] p, String destination) {

        ModuleInvokerCommand cmd = new ModuleInvokerCommand(cmdName, p);
        cmd.setDestination(destination);
        cmd.setCanRunInActiveMode(false);
        try {
            Object res = syncAgent.invoke(cmd, 5000);
            // in fact if this is an exception should mark as error!
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Exception) res, 1);
                message("error?: " + strRes, true);
            } else if (res == null) {
                strRes = "ok : VOID";
                message(strRes, false);
            } else {
                strRes = String.valueOf(res);
                message("result: " + strRes, false);
            }
            return strRes;
        } catch (Exception e) {
            message(" Exception caught :" + StackTraceFormats.toString(e, 1), true);
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString(e, 1) + "</font></html>";
        }
    }

    protected void message(String str, boolean isError) {
        (isError ? System.err : System.out).println(str);
    }

    @Override
    public void onReply(CommandReply cmd) {
        String rep = "\nReply message from " + cmd.getOrigin();
        rep += "\nCorrelID: " + cmd.getCorrelId();
        rep += "\nStatus         : " + cmd.getStatus();
        Object res = cmd.getReply();
        if (res instanceof Exception) {
            rep += "\nException:" + StackTraceFormats.toString((Exception) res, 1);
        } else if (res == null) {
            rep += "\nReply          : VOID";
        } else {
            rep += "\nReply          : " + res;
        }
        // rep += "\nCorrelId       : "+cmd.getCorrelId();
        messageFromBus(rep);
    }

    /**
     * to be overridden
     *
     * @param message
     */
    protected void messageFromBus(String message) {
        System.out.println(message);
    }

    

}
