/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class CommandListPanel extends JList<DictionaryCommand> implements TreeSelectionListener{
    private DefaultListModel cmdListModel;
    
    public CommandListPanel(){
        cmdListModel= new DefaultListModel();
        setModel(cmdListModel);
        
        getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        setCellRenderer(
                new DefaultListCellRenderer() {
                    @Override
                    public Component getListCellRendererComponent(JList<?> jlist, Object e, int i, boolean isSelected, boolean cellHasFocus) {
                        Component c = super.getListCellRendererComponent(jlist, e, i, isSelected, cellHasFocus);
                        ((JLabel) c).setText(((DictionaryCommand) e).getCommandName());
                        return c;
                    }

                });
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        TreeBranch<DictionaryContext> node = (TreeBranch<DictionaryContext>)( ((JTree)tse.getSource()).getLastSelectedPathComponent());
        if (node == null) {
            return;
        }
        Dictionary d = node.getContent().getDictionary();
        // clear the list model and the command description pane
        cmdListModel.clear();

        for (DictionaryCommand dc : d) {
            cmdListModel.addElement(dc);
        }
    }
}
