/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.DictionaryCommand;

/**
 *
 * @author emarin
 */
public class AgentListPanel extends JList<String> implements TreeSelectionListener, ActionListener {

    private List<String> agentList;
    private CommandListener commandListener;
    private GetCommandAgentWorker getCommandAgentWorker;

    public AgentListPanel(CommandListener cmdListener) {
        super();
        this.commandListener = cmdListener;
        getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        getCommandAgentWorker = new GetCommandAgentWorker();
        getCommandAgentWorker.execute();
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        getCommandAgentWorker = new GetCommandAgentWorker();
                getCommandAgentWorker.execute();
    }

    private class GetCommandAgentWorker extends SwingWorker<List<String>, String> {

        @Override
        protected List<String> doInBackground() throws Exception {
            return commandListener.getConnectedAgents();
        }

        @Override
        public void done() {
            try {
                agentList = get();
            } catch (InterruptedException ex) {
                java.util.logging.Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            } catch (ExecutionException ex) {
                java.util.logging.Logger.getLogger(DictionaryTreeMainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            setModel(new DefaultListModel<String>());
            for (String s : agentList) {
                ((DefaultListModel) getModel()).addElement(s);
            }
        }

    }

}
