/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.elog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.elog.ELogConnectionUtils;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.plugin.jas3.elog.LsstElogAttachment;

public class LsstElogSubmissionDialog
extends JPanel {
    private ElogEntry entry;
    private ArrayList<LsstElogAttachment> attachments = new ArrayList();
    private String version = "";
    private String category = "";
    private String select = "select";
    private String tagMessage;
    private JButton addAttachmentButton;
    private JLabel attachmentsLabel;
    private JPanel attachmentsPanel;
    private JComboBox categoryComboBox;
    private JLabel categoryLabel;
    private JButton clearFormButton;
    private JButton clearTagsButton;
    private JTextArea entryTextArea;
    private JLabel entryTextLabel;
    private Box.Filler filler1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel messageLabel;
    private JButton submitEntryButton;
    private JList tagList;
    private JLabel tagsLabel;
    private JLabel titleLabel;
    private JComboBox versionComboBox;
    private JLabel versionLabel;

    public LsstElogSubmissionDialog() {
        this.entry = new ElogEntry();
        this.initComponents();
        this.versionComboBox.setModel(new DefaultComboBoxModel<String>(this.extendArray(ELogConnectionUtils.getVersions())));
        this.categoryComboBox.setModel(new DefaultComboBoxModel());
        this.tagList.setModel(new DefaultListModel());
    }

    private void initComponents() {
        this.categoryLabel = new JLabel();
        this.entryTextLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.entryTextArea = new JTextArea();
        this.attachmentsLabel = new JLabel();
        this.addAttachmentButton = new JButton();
        this.tagsLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.submitEntryButton = new JButton();
        this.attachmentsPanel = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.categoryComboBox = new JComboBox();
        this.versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.tagList = new JList();
        this.messageLabel = new JLabel();
        this.clearTagsButton = new JButton();
        this.clearFormButton = new JButton();
        this.setPreferredSize(new Dimension(484, 280));
        this.categoryLabel.setText("Category:");
        this.entryTextLabel.setText("Entry Text:");
        this.entryTextArea.setColumns(20);
        this.entryTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.entryTextArea);
        this.attachmentsLabel.setText("Attachments:");
        this.addAttachmentButton.setText("Add Attachment ...");
        this.addAttachmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.addAttachmentButtonActionPerformed(evt);
            }
        });
        this.tagsLabel.setText("List of Tags:");
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("New Elog Entry Form");
        this.submitEntryButton.setText("Submit Elog Entry");
        this.submitEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.submitEntryButtonActionPerformed(evt);
            }
        });
        this.attachmentsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.attachmentsPanel.setAlignmentY(1.0f);
        this.attachmentsPanel.setMinimumSize(new Dimension(40, 40));
        this.attachmentsPanel.setLayout(new BoxLayout(this.attachmentsPanel, 1));
        this.filler1.setAlignmentY(1.0f);
        this.filler1.setAutoscrolls(true);
        this.attachmentsPanel.add(this.filler1);
        this.categoryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.categoryComboBoxActionPerformed(evt);
            }
        });
        this.versionLabel.setText("eLog Version");
        this.versionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.versionComboBoxActionPerformed(evt);
            }
        });
        this.tagList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.tagList);
        this.messageLabel.setForeground(new Color(215, 62, 34));
        this.messageLabel.setText(">");
        this.clearTagsButton.setText("Clear selected tags");
        this.clearTagsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.clearTagsButtonActionPerformed(evt);
            }
        });
        this.clearFormButton.setText("Clear Form");
        this.clearFormButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.clearFormButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tagsLabel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.versionLabel))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addAttachmentButton).addComponent(this.submitEntryButton))).addComponent(this.clearTagsButton, GroupLayout.Alignment.LEADING)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.versionComboBox, -2, 214, -2).addGap(62, 62, 62).addComponent(this.categoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.categoryComboBox, -2, 231, -2)).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.entryTextLabel).addComponent(this.jScrollPane1, -1, 753, Short.MAX_VALUE))))).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel).addComponent(this.attachmentsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.attachmentsLabel))))))).addGroup(layout.createSequentialGroup().addGap(324, 324, 324).addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearFormButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.clearFormButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryLabel).addComponent(this.categoryComboBox, -2, -1, -2).addComponent(this.versionLabel).addComponent(this.versionComboBox, -2, -1, -2)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.entryTextLabel, GroupLayout.Alignment.TRAILING).addComponent(this.tagsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(36, 36, 36)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearTagsButton).addGap(33, 33, 33))).addComponent(this.attachmentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addAttachmentButton).addComponent(this.attachmentsPanel, -1, 110, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.submitEntryButton).addComponent(this.messageLabel))));
        this.getAccessibleContext().setAccessibleName("");
    }

    private void submitEntryButtonActionPerformed(ActionEvent evt) {
        if (this.version.equals("") || this.version.startsWith(this.select)) {
            this.messageLabel.setText("> Please select version and category");
            return;
        }
        if (this.category.equals("") || this.category.startsWith(this.select)) {
            this.messageLabel.setText("> Please select category");
            return;
        }
        this.messageLabel.setText(">");
        this.entry.setCategory(this.category);
        try {
            this.entry.setFormName("default");
            this.entry.setFormField("text", this.entryTextArea.getText());
            if (this.tagList.isSelectionEmpty()) {
                this.tagMessage = "WARNING:  No tags selected. ";
                this.messageLabel.setText("> " + this.tagMessage);
            } else {
                this.tagMessage = "";
                for (Object selectedTag : this.tagList.getSelectedValuesList()) {
                    this.entry.addTag((String)selectedTag);
                }
            }
            ELogConnectionUtils.postEntryToElog((ElogEntry)this.entry, (String)this.version);
            this.entry.reset();
            SwingUtilities.invokeLater(new ClearDialog());
            this.messageLabel.setText("> " + this.tagMessage + "Entry submitted.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addAttachmentButtonActionPerformed(ActionEvent evt) {
        this.messageLabel.setText(">");
        JFileChooser dlg = new JFileChooser();
        dlg.setDialogTitle("Select an Image");
        dlg.setApproveButtonText("Select");
        if (dlg.showOpenDialog(this) == 0) {
            File file = dlg.getSelectedFile();
            try {
                String fileName = file.getName();
                LsstElogAttachment attach = new LsstElogAttachment(fileName, ElogEntry.isFileImage((String)fileName), this);
                this.attachments.add(attach);
                this.entry.addFile(fileName, file);
                SwingUtilities.invokeLater(new AddAttachment(attach));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void categoryComboBoxActionPerformed(ActionEvent evt) {
        this.messageLabel.setText(">");
        this.category = (String)this.categoryComboBox.getSelectedItem();
        this.entry.setCategory(this.category);
        try {
            List tags = ELogConnectionUtils.getTags((String)this.version);
            DefaultListModel<String> model = new DefaultListModel<String>();
            this.tagList.setModel(model);
            for (String tag : tags) {
                model.addElement(tag);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        this.messageLabel.setText(">");
        this.version = (String)this.versionComboBox.getSelectedItem();
        this.category = "";
        this.tagList.setModel(new DefaultListModel());
        if (this.version.startsWith(this.select)) {
            this.categoryComboBox.setModel(new DefaultComboBoxModel());
            return;
        }
        try {
            List categories = ELogConnectionUtils.getCategories((String)this.version);
            String[] cats = new String[categories.size()];
            cats = categories.toArray(cats);
            this.categoryComboBox.setModel(new DefaultComboBoxModel<String>(this.extendArray(cats)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void clearTagsButtonActionPerformed(ActionEvent evt) {
        this.messageLabel.setText(">");
        this.tagList.clearSelection();
    }

    private void clearFormButtonActionPerformed(ActionEvent evt) {
        this.messageLabel.setText(">");
        this.tagList.clearSelection();
        SwingUtilities.invokeLater(new ClearDialog());
    }

    void removeAttachment(LsstElogAttachment attach) {
        this.messageLabel.setText(">");
        this.attachments.remove(attach);
        this.entry.removeAttachment(attach.getFileName(), attach.isImage());
        SwingUtilities.invokeLater(new RemoveAttachment(attach));
    }

    private String[] extendArray(String[] array) {
        String[] newArray = new String[1 + array.length];
        newArray[0] = this.select;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    private class AddAttachment
    implements Runnable {
        private LsstElogAttachment attach;

        AddAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            LsstElogSubmissionDialog.this.attachmentsPanel.add((Component)this.attach, 0);
        }
    }

    private class ClearDialog
    implements Runnable {
        ClearDialog() {
        }

        @Override
        public void run() {
            for (LsstElogAttachment attach : LsstElogSubmissionDialog.this.attachments) {
                LsstElogSubmissionDialog.this.attachmentsPanel.remove(attach);
            }
            LsstElogSubmissionDialog.this.attachmentsPanel.revalidate();
            LsstElogSubmissionDialog.this.attachments.clear();
            LsstElogSubmissionDialog.this.entryTextArea.setText("");
        }
    }

    private class RemoveAttachment
    implements Runnable {
        private LsstElogAttachment attach;

        RemoveAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            LsstElogSubmissionDialog.this.attachmentsPanel.remove(this.attach);
            LsstElogSubmissionDialog.this.attachmentsPanel.revalidate();
            LsstElogSubmissionDialog.this.attachmentsPanel.repaint();
        }
    }
}

