/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.dictionary;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.framework.CommandPresenceAgent;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.plugin.jas3.dictionary.CommandListener;
import org.lsst.ccs.plugin.jas3.dictionary.DictionaryTreeMainPanel;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryBusMaster
extends BusMaster {
    private SynchronousCommandAgent syncAgent;
    private CommandPresenceAgent cpa;
    private DictionaryTreeMainPanel mainPanel;
    private static boolean useSystemLookAndFeel = true;

    public DictionaryBusMaster(String name) {
        this.setName(name);
        this.syncAgent = new SynchronousCommandAgent(this.fac);
        this.setStatusBroadcastPeriod(0);
        this.cpa = new CommandPresenceAgent(this.fac);
        this.mainPanel = new DictionaryTreeMainPanel(new CommandListener(){

            @Override
            public String sendCommand(String cmdName, Object[] cmdArgs, String destination) {
                return DictionaryBusMaster.this.executeSyncInvoke(cmdName, cmdArgs, destination);
            }

            @Override
            public List<String> getConnectedAgents() {
                return DictionaryBusMaster.this.busMasterGetConnectedAgents();
            }

            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return DictionaryBusMaster.this.busMasterBuildDictionaryTree(destination);
            }
        });
    }

    public DictionaryTreeMainPanel getMainPane() {
        return this.mainPanel;
    }

    public void initGUI() {
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }

    public List<String> busMasterGetConnectedAgents() {
        return this.cpa.listAll();
    }

    public TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {
        block10: {
            long timeout = Long.parseLong("5000");
            TreeBranch dictionaryTree = null;
            ModuleInvokerCommand cmdGetSystemDictionary = new ModuleInvokerCommand("getSystemDictionary", new Object[0]);
            cmdGetSystemDictionary.setDestination(destination);
            cmdGetSystemDictionary.setCanRunInActiveMode(false);
            try {
                Object res = this.syncAgent.invoke((Command)cmdGetSystemDictionary, timeout);
                String strRes = null;
                if (res instanceof Exception) {
                    strRes = StackTraceFormats.toString((Throwable)((Exception)res), (int)1);
                    this.message("error?: " + strRes, true);
                } else if (res == null) {
                    strRes = "ok : VOID";
                    this.message(strRes, false);
                } else {
                    strRes = String.valueOf(res);
                    this.message("result: " + strRes, false);
                    Dictionary systemDictionary = (Dictionary)res;
                    dictionaryTree = new TreeBranch((Serializable)new DictionaryContext(destination, systemDictionary));
                }
            }
            catch (Exception e) {
                this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e, (int)1), true);
            }
            ModuleInvokerCommand cmdGetComponentDictionariesTree = new ModuleInvokerCommand("getComponentDictionariesTree", new Object[0]);
            cmdGetComponentDictionariesTree.setDestination(destination);
            cmdGetComponentDictionariesTree.setCanRunInActiveMode(false);
            try {
                Object res = this.syncAgent.invoke((Command)cmdGetComponentDictionariesTree, timeout);
                String strRes = null;
                if (res instanceof Exception) {
                    strRes = StackTraceFormats.toString((Throwable)((Exception)res), (int)1);
                    this.message("error?: " + strRes, true);
                    break block10;
                }
                if (res == null) {
                    strRes = "ok : VOID";
                    this.message(strRes, false);
                    break block10;
                }
                strRes = String.valueOf(res);
                this.message("result: " + strRes, false);
                dictionaryTree.addChild((TreeBranch)res);
                return dictionaryTree;
            }
            catch (Exception e) {
                this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e, (int)1), true);
            }
        }
        return null;
    }

    public String executeSyncInvoke(String cmdName, Object[] p, String destination) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(cmdName, p);
        cmd.setDestination(destination);
        cmd.setCanRunInActiveMode(false);
        try {
            Object res = this.syncAgent.invoke((Command)cmd, 5000L);
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Throwable)((Exception)res), (int)1);
                this.message("error?: " + strRes, true);
            } else if (res == null) {
                strRes = "ok : VOID";
                this.message(strRes, false);
            } else {
                strRes = String.valueOf(res);
                this.message("result: " + strRes, false);
            }
            return strRes;
        }
        catch (Exception e) {
            this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e, (int)1), true);
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString((Throwable)e, (int)1) + "</font></html>";
        }
    }

    protected void message(String str, boolean isError) {
        (isError ? System.err : System.out).println(str);
    }

    public void onReply(CommandReply cmd) {
        String rep = "\nReply message from " + cmd.getOrigin();
        rep = String.valueOf(rep) + "\nCorrelID: " + cmd.getCorrelId();
        rep = String.valueOf(rep) + "\nStatus         : " + cmd.getStatus();
        Object res = cmd.getReply();
        rep = res instanceof Exception ? String.valueOf(rep) + "\nException:" + StackTraceFormats.toString((Throwable)((Exception)res), (int)1) : (res == null ? String.valueOf(rep) + "\nReply          : VOID" : String.valueOf(rep) + "\nReply          : " + res);
        this.messageFromBus(rep);
    }

    protected void messageFromBus(String message) {
        System.out.println(message);
    }
}

