/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import jas.hist.JASHistData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.plotter.JAS3Plot;
import org.freehep.jas.plugin.plotter.PlotterAdapterLookup;
import org.freehep.jas.plugin.plotter.PlotterPlugin;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.Plotter;
import org.freehep.jas.services.PlotterAdapter;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.Content;
import org.jdom.Element;

public class DefaultPlotter
implements Plotter,
XMLIO {
    private JAS3Plot plot = new JAS3Plot();
    private PlotterAdapterLookup plotterAdapterLookup;
    private PlotFactory factory;
    protected List dataList = new ArrayList();

    public DefaultPlotter(PlotFactory factory) {
        this.factory = factory;
        this.plotterAdapterLookup = ((PlotterPlugin)factory).plotterAdapterLookup();
    }

    @Override
    public void clear() {
        this.plot.removeAllData();
        this.plot.clearDataList();
        this.dataList.clear();
        this.plot.getXAxis().setLabel("");
        this.plot.getYAxis().setLabel("");
    }

    public JAS3Plot getPlot() {
        return this.plot;
    }

    @Override
    public void plot(Object data, int mode) {
        this.plot(data, mode, null, null);
    }

    @Override
    public void plot(Object data, int mode, Object style, String options) {
        JAS3DataSource jas3DataSource;
        if (mode != 0 && mode != 1) {
            throw new UnsupportedOperationException();
        }
        if (mode != 1) {
            this.clear();
        }
        if (data instanceof JAS3DataSource) {
            jas3DataSource = (JAS3DataSource)data;
        } else {
            PlotterAdapter adapter = this.plotterAdapterLookup.adapter(data.getClass(), JAS3DataSource.class);
            if (adapter != null) {
                jas3DataSource = (JAS3DataSource)adapter.adapt(data);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        this.plot.addJAS3Data(jas3DataSource);
        JASHistData jasHistData = this.plot.addData(jas3DataSource.dataSource());
        jasHistData.show(true);
        this.dataList.add(data);
    }

    @Override
    public void remove(Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component viewable() {
        return this.plot;
    }

    public void restore(XMLIOManager xmlioManager, Element nodeEl) {
        List children = nodeEl.getChildren();
        if (children.size() == 1) {
            JAS3Plot plot = (JAS3Plot)xmlioManager.restore((Element)children.get(0));
            List data = plot.data();
            this.plot(data.get(0), 0);
            for (int i = 1; i < data.size(); ++i) {
                this.plot(data.get(i), 1);
            }
        }
    }

    public void save(XMLIOManager xmlioManager, Element nodeEl) {
        JAS3Plot c = this.getPlot();
        if (c != null) {
            nodeEl.addContent((Content)xmlioManager.save((Object)c));
        }
    }

    @Override
    public List getData() {
        return this.dataList;
    }
}

