/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginException;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.util.VersionComparator;

public final class PluginMap {
    private Studio app;
    private EnumMap<PluginDir, Map<String, PluginInfo>> pluginMap;
    private EnumMap<PluginDir, Map<String, LibInfo>> libMap;
    private ArrayList<LibInfo> duplicateLibraries;
    private ArrayList<PluginInfo> inMemoryPlugins;
    private volatile Map<String, LibInfo> activeLibraries;
    private volatile Map<String, PluginInfo> activePlugins;
    private volatile EnumMap<PluginDir, ArrayList<LibInfo>> unclaimedLibraries;
    private ArrayList<LibInfo> missingLibraries;
    private EnumMap<PluginDir, Map<String, String>> name2id;
    private static final String ID_MAP_NAME = "library.map";

    public PluginMap(Studio application) {
        this.app = application;
        this.scan();
    }

    protected PluginMap(Collection<PluginInfo> plugins) {
        for (PluginInfo plugin : plugins) {
            PluginDir dir = (plugin = new PluginInfo(plugin)).getDirectory();
            Map<String, PluginInfo> dirMapPlugin = this.pluginMap.get((Object)dir);
            if (dirMapPlugin == null) {
                dirMapPlugin = new LinkedHashMap<String, PluginInfo>();
                this.pluginMap.put(dir, dirMapPlugin);
            }
            dirMapPlugin.put(plugin.getName(), plugin);
            Map<String, LibInfo> dirMapLib = this.libMap.get((Object)dir);
            if (dirMapLib == null) {
                dirMapLib = new LinkedHashMap<String, LibInfo>();
                this.libMap.put(dir, dirMapLib);
            }
            for (LibInfo lib : plugin.getLibraries()) {
                lib = new LibInfo(lib);
                lib.setDir(dir);
                LibInfo other = dirMapLib.get(lib.getId());
                if (other != null && other.getVersion() != null && (lib.getVersion() == null || VersionComparator.compareVersion((String)lib.getVersion(), (String)other.getVersion()) <= 0)) continue;
                dirMapLib.put(lib.getId(), lib);
            }
        }
    }

    public synchronized void scan() {
        this.invalidate();
        this.pluginMap = new EnumMap(PluginDir.class);
        this.libMap = new EnumMap(PluginDir.class);
        this.name2id = new EnumMap(PluginDir.class);
        this.duplicateLibraries = new ArrayList();
        for (PluginDir extdir : PluginDir.values()) {
            this.scanDirectory(extdir);
        }
        if (this.inMemoryPlugins != null) {
            for (PluginInfo plugin : this.inMemoryPlugins) {
                this.addPlugin(plugin);
            }
        }
        if (this.duplicateLibraries.isEmpty()) {
            this.duplicateLibraries = null;
        } else {
            this.duplicateLibraries.trimToSize();
        }
    }

    private void scanDirectory(PluginDir dir) {
        String dirPath = this.app.getExtensionsDir(dir);
        if (dirPath == null) {
            return;
        }
        File extdir = new File(dirPath);
        if (!extdir.isDirectory()) {
            return;
        }
        this.invalidate();
        File infile = new File(dirPath, ID_MAP_NAME);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(infile));
            HashMap<String, String> map = new HashMap<String, String>();
            this.name2id.put(dir, map);
            while ((line = reader.readLine()) != null) {
                String[] mapping = line.trim().split("\\s");
                if (mapping.length != 2) continue;
                map.put(mapping[0], mapping[1]);
            }
            reader.close();
        }
        catch (FileNotFoundException x) {
            this.name2id.remove((Object)dir);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        LinkedHashMap<String, PluginInfo> dirMapPlug = new LinkedHashMap<String, PluginInfo>();
        LinkedHashMap<String, LibInfo> dirMapLib = new LinkedHashMap<String, LibInfo>();
        String[] files = extdir.list();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith(".jar") && !file.endsWith(".tmp")) continue;
            File f = new File(extdir, file);
            if (f.length() > 0L) {
                try {
                    JarFile jarFile = new JarFile(f);
                    JarEntry manifest = jarFile.getJarEntry("PLUGIN-inf/plugins.xml");
                    if (manifest != null) {
                        InputStream in = jarFile.getInputStream(manifest);
                        List<PluginInfo> newPlugins = this.app.buildPluginList(in);
                        for (PluginInfo plugin : newPlugins) {
                            PluginInfo prev;
                            plugin.setDirectory(dir);
                            this.translateLibraryIDs(plugin);
                            if (!plugin.isApplicationCompatible(this.app) || !plugin.isJavaCompatible() || this.app.isBlacklisted(plugin) || (prev = (PluginInfo)dirMapPlug.get(plugin.getName())) != null && VersionComparator.compareVersion((String)prev.getVersion(), (String)plugin.getVersion()) >= 0) continue;
                            dirMapPlug.put(plugin.getName(), plugin);
                        }
                    }
                    jarFile.close();
                    LibInfo library = new LibInfo(f, dir);
                    LibInfo prev = (LibInfo)dirMapLib.get(library.getId());
                    if (prev == null) {
                        dirMapLib.put(library.getId(), library);
                        continue;
                    }
                    if (prev.getVersion() == null || library.getVersion() != null && VersionComparator.compareVersion((String)library.getVersion(), (String)prev.getVersion()) > 0) {
                        dirMapLib.put(library.getId(), library);
                        this.duplicateLibraries.add(prev);
                        continue;
                    }
                    this.duplicateLibraries.add(library);
                }
                catch (IOException x) {
                    System.err.println("Error reading extension file " + file + " : " + x);
                }
                continue;
            }
            f.delete();
        }
        if (!dirMapPlug.isEmpty() || !this.libMap.isEmpty()) {
            this.pluginMap.put(dir, dirMapPlug);
            this.libMap.put(dir, dirMapLib);
        }
    }

    public synchronized void insertPlugins(Collection<PluginInfo> plugins) {
        for (PluginInfo plugin : plugins) {
            PluginDir dir = plugin.getDirectory();
            if (this.getPlugin(plugin.getName(), dir) != null) continue;
            this.addPlugin(plugin);
            if (dir == PluginDir.BUILTIN) {
                for (LibInfo lib : plugin.getLibraries()) {
                    LibInfo already = this.getLibrary(lib.getId(), dir);
                    if (already != null) continue;
                    Map<String, LibInfo> dirMap = this.libMap.get((Object)PluginDir.BUILTIN);
                    if (dirMap == null) {
                        dirMap = new LinkedHashMap<String, LibInfo>();
                        this.libMap.put(PluginDir.BUILTIN, dirMap);
                    }
                    dirMap.put(lib.getId(), new LibInfo(lib));
                }
                continue;
            }
            this.missingLibraries = null;
        }
    }

    public synchronized void processUnclaimedLibraries(Orphan action) {
        EnumMap<PluginDir, ArrayList<LibInfo>> unclaimedLibs;
        if (action != Orphan.Remove && !(unclaimedLibs = this.getUnclaimedLibraries()).isEmpty()) {
            for (PluginDir dir : unclaimedLibs.keySet()) {
                List unclaimed = unclaimedLibs.get((Object)dir);
                ArrayList<LibInfo> libs = new ArrayList<LibInfo>(unclaimed.size());
                StringBuilder pluginDescription = new StringBuilder("Libraries found in the ");
                pluginDescription.append(dir.getLabel()).append(" extensions directory but not claimed by any installed plugins:");
                for (LibInfo lib : unclaimed) {
                    StringBuilder location = new StringBuilder(lib.getId());
                    if (lib.getVersion() != null) {
                        location.append("-").append(lib.getVersion());
                    }
                    location.append(".jar");
                    String href = null;
                    try {
                        href = lib.getFile().toURI().toURL().toString();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    String fileName = location.toString();
                    libs.add(new LibInfo(fileName, href));
                    pluginDescription.append("\n").append(fileName);
                }
                PluginInfo unclaimedPlugin = new PluginInfo(this.getUnclaimedPluginName(dir), "", "1.0", null, "Unclaimed libraries", pluginDescription.toString(), null, action == Orphan.Load);
                unclaimedPlugin.setDirectory(dir);
                unclaimedPlugin.setLibraries(libs);
                this.addPlugin(unclaimedPlugin);
                if (this.inMemoryPlugins == null) {
                    this.inMemoryPlugins = new ArrayList(1);
                }
                this.inMemoryPlugins.add(unclaimedPlugin);
            }
            this.invalidate();
        }
    }

    public synchronized PluginMap add(Collection<PluginInfo> plugins) {
        ArrayList<PluginInfo> pluginsToBeInstalled = new ArrayList<PluginInfo>(plugins.size());
        for (PluginInfo plugin : plugins) {
            PluginInfo installed = this.getPlugin(plugin.getName(), plugin.getDirectory());
            if (installed != null && VersionComparator.compareVersion((String)installed.getVersion(), (String)plugin.getVersion()) >= 0) continue;
            pluginsToBeInstalled.add(plugin);
            this.translateLibraryIDs(plugin);
        }
        PluginMap updateMap = new PluginMap(pluginsToBeInstalled);
        for (LibInfo candidate : updateMap.getLibraries()) {
            LibInfo installed = this.getLibrary(candidate.getId(), candidate.getDir());
            String candidateVersion = candidate.getVersion();
            if (installed != null && installed.getVersion() != null && candidateVersion != null && VersionComparator.compareVersion((String)installed.getVersion(), (String)candidateVersion) >= 0) continue;
            candidate.setFile(this.makePath(candidate, "tmp"));
        }
        return updateMap;
    }

    public synchronized void commit(List<LibInfo> libraries) {
        EnumSet<PluginDir> addedToIdMap = EnumSet.noneOf(PluginDir.class);
        for (LibInfo candidate : libraries) {
            String id;
            if (candidate.getFile() == null || candidate.getVersion() != null || !candidate.checkMavenID()) continue;
            String location = candidate.getLocation();
            if (!location.equals(id = candidate.getId())) {
                this.idMapPut(candidate.getDir(), location, id);
                addedToIdMap.add(candidate.getDir());
            }
            File renameTo = this.makePath(candidate, "tmp");
            File renameFrom = candidate.getFile();
            if (!renameFrom.renameTo(renameTo)) continue;
            candidate.setFile(renameTo);
        }
        for (PluginDir dir : addedToIdMap) {
            this.saveIdMap(dir);
        }
        this.scan();
        this.purge();
    }

    public synchronized boolean remove(Collection<PluginInfo> plugins) {
        boolean restart = false;
        for (PluginInfo plugin : plugins) {
            restart = restart || this.isLoaded(plugin);
            this.removePlugin(plugin);
        }
        this.invalidate();
        restart = this.removeUnclaimedLibraries() || restart;
        this.updateIdMap();
        return restart;
    }

    public synchronized void purge() {
        if (this.duplicateLibraries != null) {
            for (LibInfo lib : this.duplicateLibraries) {
                lib.getFile().delete();
            }
            this.duplicateLibraries = null;
        }
        this.removeUnclaimedLibraries();
        for (LibInfo lib : this.getLibraries()) {
            File newFile;
            File file;
            String path;
            if (lib.getDir() == PluginDir.BUILTIN || !(path = (file = lib.getFile()).getPath()).endsWith(".tmp") || this.isLoaded(newFile = new File(path = path.substring(0, path.length() - 4) + ".jar")) || !file.renameTo(newFile)) continue;
            lib.setFile(newFile.getAbsoluteFile());
        }
        this.updateIdMap();
    }

    public synchronized void invalidate() {
        this.activeLibraries = null;
        this.activePlugins = null;
        this.unclaimedLibraries = null;
        this.missingLibraries = null;
    }

    public synchronized Map<String, PluginInfo> getActivePlugins() {
        if (this.activePlugins == null) {
            this.activePlugins = new HashMap<String, PluginInfo>();
            for (PluginDir dir : PluginDir.inverseSearchOrder()) {
                Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)dir);
                if (dirMap == null) continue;
                for (Map.Entry<String, PluginInfo> entry : dirMap.entrySet()) {
                    PluginInfo plugin = entry.getValue();
                    this.activePlugins.put(entry.getKey(), plugin);
                }
            }
            this.chooseActiveLibraries();
            this.missingLibraries = new ArrayList();
            for (PluginInfo plugin : this.activePlugins.values()) {
                PluginException.reportNoMissingPlugins(plugin);
                PluginException.reportNoMissingLibraries(plugin);
                for (LibInfo lib : plugin.getLibraries()) {
                    if (this.getActiveLibrary(lib) != null) continue;
                    this.missingLibraries.add(lib);
                    PluginException.reportMissingLibrary(plugin, lib.getId());
                }
            }
            for (PluginInfo plugin : this.activePlugins.values()) {
                HashSet<String> visited = new HashSet<String>(this.activePlugins.size() * 2);
                ArrayDeque<PluginInfo> dfs = new ArrayDeque<PluginInfo>(visited.size());
                dfs.push(plugin);
                while (!dfs.isEmpty()) {
                    PluginInfo plug = (PluginInfo)dfs.pop();
                    for (String requiredName : plug.getRequiredPluginNames()) {
                        PluginInfo requiredPlugin = this.activePlugins.get(requiredName);
                        if (plug.isRequiredPluginValid(requiredPlugin) && requiredPlugin.getErrorStatus() == null) {
                            if (visited.add(requiredName)) continue;
                            dfs.push(plug);
                            continue;
                        }
                        PluginException.reportMissingPlugin(plugin, requiredName);
                    }
                }
            }
        }
        return Collections.unmodifiableMap(this.activePlugins);
    }

    public synchronized Map<String, PluginInfo> getLoadablePlugins() {
        Map<String, PluginInfo> active = this.getActivePlugins();
        HashMap<String, PluginInfo> out = new HashMap<String, PluginInfo>(active.size() * 2);
        ArrayDeque<PluginInfo> queue = new ArrayDeque<PluginInfo>(active.size() * 2);
        for (PluginInfo plugin : active.values()) {
            if (plugin.getErrorStatus() != null || !plugin.isLoadAtStart()) continue;
            out.put(plugin.getName(), plugin);
            for (String name : plugin.getRequiredPluginNames()) {
                PluginInfo alreadyAdded;
                PluginInfo dependency = active.get(name);
                if (dependency == null || dependency.getErrorStatus() != null || (alreadyAdded = out.put(name, dependency)) != null) continue;
                queue.add(dependency);
            }
        }
        while (!queue.isEmpty()) {
            PluginInfo plugin = (PluginInfo)queue.poll();
            for (String name : plugin.getRequiredPluginNames()) {
                PluginInfo dependency;
                PluginInfo alreadyAdded = out.put(name, dependency = active.get(name));
                if (alreadyAdded != null) continue;
                queue.add(dependency);
            }
        }
        return out;
    }

    public synchronized Map<String, LibInfo> getActiveLibraries() {
        if (this.activeLibraries == null) {
            this.getActivePlugins();
        }
        return Collections.unmodifiableMap(this.activeLibraries);
    }

    public synchronized List<LibInfo> getMissingLibraries() {
        if (this.missingLibraries == null) {
            this.getActivePlugins();
        }
        return Collections.unmodifiableList(this.missingLibraries);
    }

    public synchronized Map<String, LibInfo> getActiveLibraries(PluginInfo plugin) {
        if (this.activeLibraries == null) {
            this.getActivePlugins();
        }
        HashMap<String, LibInfo> out = new HashMap<String, LibInfo>();
        for (LibInfo aim : plugin.getLibraries()) {
            LibInfo target = this.getActiveLibrary(aim);
            if (target == null) {
                throw new IllegalArgumentException(aim.getId());
            }
            out.put(target.getId(), target);
        }
        return out;
    }

    public synchronized LibInfo getActiveLibrary(LibInfo library) {
        LibInfo target;
        if (this.activeLibraries == null) {
            this.getActivePlugins();
        }
        if ((target = this.activeLibraries.get(library.getId())) == null) {
            String location = library.getLocation();
            for (LibInfo lib : this.activeLibraries.values()) {
                if (lib == null || !location.equals(lib.getLocation())) continue;
                target = lib;
                break;
            }
        }
        return target;
    }

    public synchronized URL[] getExtensionClasspath() {
        Map<String, LibInfo> al = this.getActiveLibraries();
        ArrayList<URL> alList = new ArrayList<URL>(al.size());
        try {
            for (LibInfo lib : al.values()) {
                File f = lib.getFile();
                if (f == null) continue;
                alList.add(f.toURI().toURL());
            }
        }
        catch (MalformedURLException x) {
            throw new RuntimeException(x);
        }
        return alList.toArray(new URL[alList.size()]);
    }

    public synchronized List<PluginInfo> getPlugins() {
        ArrayList<PluginInfo> out = new ArrayList<PluginInfo>(20);
        for (Map<String, PluginInfo> dirMap : this.pluginMap.values()) {
            if (dirMap == null) continue;
            for (PluginInfo plugin : dirMap.values()) {
                out.add(plugin);
            }
        }
        return out;
    }

    public synchronized Map<String, PluginInfo> getPlugins(PluginDir dir) {
        Map<String, PluginInfo> out = this.pluginMap.get((Object)dir);
        return out == null ? Collections.emptyMap() : Collections.unmodifiableMap(out);
    }

    public synchronized PluginInfo getPlugin(String name) {
        return this.getActivePlugins().get(name);
    }

    public synchronized PluginInfo getPlugin(String name, PluginDir dir) {
        Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)dir);
        return dirMap == null ? null : dirMap.get(name);
    }

    public synchronized List<LibInfo> getLibraries() {
        ArrayList<LibInfo> out = new ArrayList<LibInfo>(50);
        for (Map<String, LibInfo> dirMap : this.libMap.values()) {
            if (dirMap == null) continue;
            for (LibInfo lib : dirMap.values()) {
                out.add(lib);
            }
        }
        return out;
    }

    public synchronized Collection<LibInfo> getLibraries(PluginDir dir) {
        Map<String, LibInfo> dirMap = this.libMap.get((Object)dir);
        if (dirMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(dirMap.values());
    }

    public synchronized LibInfo getLibrary(String id, PluginDir dir) {
        Map<String, LibInfo> dirMap = this.libMap.get((Object)dir);
        if (dirMap == null) {
            return null;
        }
        return dirMap.get(id);
    }

    public synchronized LibInfo getLibrary(LibInfo library) {
        PluginDir dir = library.getDir();
        Map<String, LibInfo> dirMap = this.libMap.get((Object)dir);
        if (dirMap == null) {
            return null;
        }
        LibInfo out = dirMap.get(library.getId());
        if (out == null && dir != PluginDir.BUILTIN) {
            for (LibInfo lib : dirMap.values()) {
                if (!lib.getLocation().equals(library.getLocation())) continue;
                return lib;
            }
        }
        return out;
    }

    public synchronized Set<PluginInfo> getDependentPlugins(PluginInfo plugin) {
        HashSet<PluginInfo> out = new HashSet<PluginInfo>();
        Map<String, PluginInfo> all = this.getPlugins(plugin.getDirectory());
        this.findDependentPlugins(plugin, out, all);
        return out;
    }

    public synchronized EnumMap<PluginDir, ArrayList<LibInfo>> getUnclaimedLibraries() {
        if (this.unclaimedLibraries == null) {
            this.unclaimedLibraries = new EnumMap(PluginDir.class);
            for (PluginDir dir : PluginDir.sgu()) {
                ArrayList<LibInfo> unclaimed = null;
                Collection<LibInfo> libs = this.getLibraries(dir);
                for (LibInfo lib : libs) {
                    if (!this.getReferencingPlugins(lib).isEmpty()) continue;
                    if (unclaimed == null) {
                        unclaimed = new ArrayList<LibInfo>(libs.size());
                    }
                    unclaimed.add(lib);
                }
                if (unclaimed == null) continue;
                unclaimed.trimToSize();
                this.unclaimedLibraries.put(dir, unclaimed);
            }
        }
        return this.unclaimedLibraries;
    }

    public synchronized List<LibInfo> getDownloads(Collection<PluginInfo> plugins, Map<String, PluginInfo> available) {
        ArrayList<PluginInfo> all = new ArrayList<PluginInfo>(plugins.size());
        for (PluginDir dir : PluginDir.sgu()) {
            HashMap<String, PluginInfo> dirMap = new HashMap<String, PluginInfo>(plugins.size() * 2);
            for (PluginInfo plugin : plugins) {
                if (plugin.getDirectory() != dir) continue;
                this.addWithDependencies(plugin, dirMap, available);
            }
            all.addAll(dirMap.values());
        }
        return this.getDownloads(all);
    }

    public synchronized List<LibInfo> getDownloads(Collection<PluginInfo> plugins) {
        ArrayList<LibInfo> all = new ArrayList<LibInfo>(64);
        for (PluginDir dir : PluginDir.sgu()) {
            HashMap<String, LibInfo> dirMap = new HashMap<String, LibInfo>();
            for (PluginInfo plugin : plugins) {
                if (plugin.getDirectory() != dir) continue;
                for (LibInfo candidate : plugin.getLibraries()) {
                    String id = candidate.getId();
                    String candidateVersion = candidate.getVersion();
                    LibInfo chosen = (LibInfo)dirMap.get(id);
                    if (chosen == null) {
                        LibInfo installed = this.getLibrary(id, dir);
                        if (installed != null && (candidateVersion == null || installed.getVersion() != null && VersionComparator.compareVersion((String)candidateVersion, (String)installed.getVersion()) <= 0)) continue;
                        dirMap.put(id, candidate);
                        continue;
                    }
                    String chosenVersion = chosen.getVersion();
                    if (chosenVersion != null && (candidateVersion == null || VersionComparator.compareVersion((String)candidateVersion, (String)chosenVersion) <= 0)) continue;
                    dirMap.put(id, candidate);
                }
            }
            for (LibInfo lib : dirMap.values()) {
                lib = new LibInfo(lib);
                lib.setFile(this.makePath(lib, "tmp"));
                all.add(lib);
            }
        }
        return all;
    }

    public List<LibInfo> getDownloads(Collection<LibInfo> libraries, boolean checkInstalled) {
        ArrayList<LibInfo> out = new ArrayList<LibInfo>(libraries.size());
        for (LibInfo lib : libraries) {
            LibInfo installed;
            if (checkInstalled && (installed = this.getLibrary(lib.getId(), lib.getDir())) != null && installed.getVersion() != null && lib.getVersion() != null && VersionComparator.compareVersion((String)lib.getVersion(), (String)installed.getVersion()) <= 0) break;
            lib = new LibInfo(lib);
            lib.setFile(this.makePath(lib, "tmp"));
            out.add(lib);
        }
        return out;
    }

    private void addWithDependencies(PluginInfo plugin, Map<String, PluginInfo> target, Map<String, PluginInfo> available) {
        String name = plugin.getName();
        if (target.containsKey(name)) {
            return;
        }
        target.put(name, plugin);
        for (String requiredName : plugin.getRequiredPluginNames()) {
            PluginInfo candidate;
            if (target.containsKey(requiredName) || !plugin.isRequiredPluginValid(candidate = available.get(requiredName))) continue;
            candidate = new PluginInfo(candidate);
            candidate.setDirectory(plugin.getDirectory());
            this.addWithDependencies(candidate, target, available);
        }
    }

    private String getUnclaimedPluginName(PluginDir dir) {
        return "Unclaimed libraries in " + dir.getLabel() + " directory";
    }

    private void chooseActiveLibraries() {
        this.activeLibraries = new HashMap<String, LibInfo>();
        HashMap<String, EnumSet<PluginDir>> id2dirs = new HashMap<String, EnumSet<PluginDir>>();
        for (PluginInfo pluginInfo : this.activePlugins.values()) {
            PluginDir dir = pluginInfo.getDirectory();
            for (LibInfo lib : pluginInfo.getLibraries()) {
                String id = this.getId(lib);
                EnumSet<PluginDir> dirSet = (EnumSet<PluginDir>)id2dirs.get(id);
                if (dirSet == null) {
                    dirSet = EnumSet.of(dir);
                    id2dirs.put(id, dirSet);
                    continue;
                }
                dirSet.add(dir);
            }
        }
        for (Map.Entry entry : id2dirs.entrySet()) {
            String id = (String)entry.getKey();
            LibInfo lib = this.getLibrary(id, PluginDir.BUILTIN);
            if (lib == null) {
                LibInfo candidate;
                PluginDir dir;
                EnumSet dirSet = (EnumSet)entry.getValue();
                PluginDir[] arr$ = PluginDir.ugs();
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || dirSet.contains((Object)(dir = arr$[i$])) && (candidate = this.getLibrary(id, dir)) != null && (lib == null || candidate.getVersion() != null && VersionComparator.compareVersion((String)lib.getVersion(), (String)candidate.getVersion()) < 0) && (lib = candidate).getVersion() == null); ++i$) {
                }
            }
            this.activeLibraries.put(id, lib);
        }
    }

    private boolean removeUnclaimedLibraries() {
        boolean restart = false;
        for (ArrayList<LibInfo> libs : this.getUnclaimedLibraries().values()) {
            for (LibInfo lib : libs) {
                restart = this.removeLibrary(lib) || restart;
            }
            this.invalidate();
        }
        return restart;
    }

    private void findDependentPlugins(PluginInfo plugin, Set<PluginInfo> out, Map<String, PluginInfo> all) {
        for (PluginInfo p : all.values()) {
            if (!p.getRequiredPluginNames().contains(plugin.getName()) || !out.add(p)) continue;
            this.findDependentPlugins(p, out, all);
        }
    }

    private void removePlugin(PluginInfo plugin) {
        Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)plugin.getDirectory());
        if (dirMap != null) {
            dirMap.remove(plugin.getName());
            if (dirMap.isEmpty()) {
                this.pluginMap.remove((Object)plugin.getDirectory());
            }
        }
    }

    private void addPlugin(PluginInfo plugin) {
        Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)plugin.getDirectory());
        if (dirMap == null) {
            dirMap = new LinkedHashMap<String, PluginInfo>();
            this.pluginMap.put(plugin.getDirectory(), dirMap);
        }
        dirMap.put(plugin.getName(), plugin);
    }

    private boolean removeLibrary(LibInfo library) {
        boolean restart = false;
        Map<String, LibInfo> dirMap = this.libMap.get((Object)library.getDir());
        if (dirMap != null) {
            File file;
            LibInfo lib = dirMap.remove(library.getId());
            if (dirMap.isEmpty()) {
                this.libMap.remove((Object)library.getDir());
            }
            if (lib != null && (file = lib.getFile()) != null) {
                if (this.isLoaded(file)) {
                    this.markFileForDeletion(file);
                    restart = true;
                } else if (file.delete()) {
                    restart = false;
                } else {
                    this.markFileForDeletion(file);
                    restart = true;
                }
            }
        }
        return restart;
    }

    private boolean addLibrary(LibInfo library) {
        boolean restart = false;
        Map<String, LibInfo> dirMap = this.libMap.get((Object)library.getDir());
        if (dirMap == null) {
            dirMap = new LinkedHashMap<String, LibInfo>();
            this.libMap.put(library.getDir(), dirMap);
        } else {
            LibInfo old = dirMap.get(library.getId());
            if (old != null) {
                File oldFile = old.getFile();
                restart = this.isLoaded(oldFile) ? true : !oldFile.delete() || restart;
            }
        }
        dirMap.put(library.getId(), library);
        if (!restart && library.getFile().getName().endsWith(".tmp")) {
            File renameTo = this.makePath(library, "jar");
            boolean bl = restart = this.isLoaded(renameTo) || !library.getFile().renameTo(renameTo);
            if (!restart) {
                library.setFile(renameTo);
            }
        }
        return restart;
    }

    private Set<PluginInfo> getReferencingPlugins(LibInfo library) {
        Set<PluginInfo> out = Collections.newSetFromMap(new IdentityHashMap());
        PluginDir dir = library.getDir();
        Map<String, PluginInfo> dirMap = this.getPlugins(dir);
        for (PluginInfo plugin : dirMap.values()) {
            for (LibInfo lib : plugin.getLibraries()) {
                if (library != this.getLibrary(lib)) continue;
                out.add(plugin);
            }
        }
        return out;
    }

    private String idMapPut(PluginDir dir, String location, String id) {
        Map<String, String> dirMap = this.name2id.get((Object)dir);
        if (dirMap == null) {
            dirMap = new HashMap<String, String>();
            this.name2id.put(dir, dirMap);
        }
        return dirMap.put(location, id);
    }

    private String idMapRemove(PluginDir dir, String location) {
        Map<String, String> dirMap = this.name2id.get((Object)dir);
        if (dirMap == null) {
            return null;
        }
        String out = dirMap.remove(location);
        if (dirMap.isEmpty()) {
            this.name2id.remove((Object)dir);
        }
        return out;
    }

    private String idMapGet(PluginDir dir, String location) {
        Map<String, String> dirMap = this.name2id.get((Object)dir);
        if (dirMap == null) {
            return location;
        }
        String id = dirMap.get(location);
        return id == null ? location : id;
    }

    protected String getId(LibInfo library) {
        String id = library.getId();
        if (library.getVersion() == null) {
            id = this.idMapGet(library.getDir(), id);
        }
        return id;
    }

    private void translateLibraryIDs(PluginInfo plugin) {
        Map<String, String> idMap = this.name2id.get((Object)plugin.getDirectory());
        if (idMap != null) {
            for (LibInfo lib : plugin.getLibraries()) {
                String translatedID;
                if (lib.getVersion() != null || (translatedID = idMap.get(lib.getLocation())) == null) continue;
                lib.setId(translatedID);
            }
        }
    }

    private File makePath(LibInfo library, String extension) {
        String version = library.getVersion();
        StringBuilder sb = new StringBuilder(library.getId());
        if (version != null) {
            sb.append('-').append(version);
        }
        sb.append('.').append(extension);
        File out = new File(this.app.getExtensionsDir(library.getDir()), sb.toString());
        return out.getAbsoluteFile();
    }

    private boolean isLoaded(File file) {
        ExtensionClassLoader loader = this.app.getExtensionLoader();
        if (loader == null) {
            return false;
        }
        URL[] classpath = loader.getURLs();
        try {
            URL url = file.toURI().toURL();
            for (URL u : classpath) {
                if (!u.equals(url)) continue;
                return true;
            }
        }
        catch (MalformedURLException x) {
            // empty catch block
        }
        return false;
    }

    private boolean isLoaded(PluginInfo plugin) {
        String name = plugin.getName();
        PluginDir dir = plugin.getDirectory();
        for (PluginInfo loaded : this.app.getPlugins()) {
            if (!name.equals(loaded.getName()) || dir != loaded.getDirectory()) continue;
            return true;
        }
        return false;
    }

    private void updateIdMap() {
        HashSet<String> builtin = new HashSet<String>();
        Map<String, LibInfo> bm = this.libMap.get((Object)PluginDir.BUILTIN);
        if (bm != null) {
            builtin.addAll(bm.keySet());
        }
        for (PluginDir dir : PluginDir.sgu()) {
            File f;
            Map<String, String> n2id;
            Map<String, PluginInfo> pn2pi = this.pluginMap.get((Object)dir);
            if (pn2pi == null) {
                this.name2id.remove((Object)dir);
            }
            if ((n2id = this.name2id.get((Object)dir)) != null) {
                HashSet<String> names = new HashSet<String>();
                for (PluginInfo plugin : pn2pi.values()) {
                    for (LibInfo lib : plugin.getLibraries()) {
                        names.add(lib.getLocation());
                    }
                }
                HashSet<String> ids = new HashSet<String>();
                Map<String, LibInfo> libs = this.libMap.get((Object)dir);
                if (libs != null) {
                    ids.addAll(libs.keySet());
                }
                ids.addAll(builtin);
                Iterator<Map.Entry<String, String>> it = n2id.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> e = it.next();
                    String name = e.getKey();
                    if (names.contains(name) && !ids.contains(name)) continue;
                    it.remove();
                }
                if (n2id.isEmpty()) {
                    this.pluginMap.remove((Object)dir);
                    n2id = null;
                }
            }
            if ((f = new File(this.app.getExtensionsDir(dir), ID_MAP_NAME)).exists()) {
                f.delete();
            }
            if (n2id == null) continue;
            try {
                PrintWriter pw = new PrintWriter(f);
                for (Map.Entry<String, String> e : n2id.entrySet()) {
                    pw.println(e.getKey() + " " + e.getValue());
                }
                pw.close();
            }
            catch (FileNotFoundException x) {
                throw new IllegalArgumentException(x);
            }
        }
    }

    private void saveIdMap(PluginDir dir) {
        Map<String, String> dirMap = this.name2id == null ? null : this.name2id.get((Object)dir);
        String dirName = this.app.getExtensionsDir(dir);
        if (dirName == null) {
            return;
        }
        File f = new File(dirName, ID_MAP_NAME);
        if (f.exists()) {
            f.delete();
        }
        if (dirMap == null || dirMap.isEmpty()) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(f);
            for (Map.Entry<String, String> e : dirMap.entrySet()) {
                pw.println(e.getKey() + " " + e.getValue());
            }
            pw.close();
        }
        catch (FileNotFoundException x) {
            throw new IllegalArgumentException(x);
        }
    }

    private boolean markFileForDeletion(File file) {
        try {
            new FileOutputStream(file).close();
            return true;
        }
        catch (IOException x) {
            return false;
        }
    }

    public static enum Orphan {
        Remove,
        Ignore,
        Load;

    }
}

