/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.util.SubnetUtils;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;

public class JythonConsoleNetworkUtilities {
    public static boolean isInetAddressLocalhost(InetAddress address) throws UnknownHostException {
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            return true;
        }
        InetAddress localhost = InetAddress.getLocalHost();
        return localhost.getHostAddress().equals(address.getHostAddress());
    }

    public static boolean isIpAddressAllowed(String address, List<SubnetUtils> subnetUtilsList) {
        for (SubnetUtils utils : subnetUtilsList) {
            if (!utils.getInfo().getAddress().equals(address) && !utils.getInfo().isInRange(address)) continue;
            return true;
        }
        return false;
    }

    public static List<SubnetUtils> loadNetwrokAccessInformation() {
        ArrayList<SubnetUtils> accessList = new ArrayList<SubnetUtils>();
        InputStream accessInputStream = BootstrapResourceUtils.getBootstrapResource((String)"access.list");
        if (accessInputStream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(accessInputStream));
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    String address = null;
                    String mask = null;
                    int separator = line.indexOf("/");
                    if (separator > -1) {
                        address = line.substring(0, separator);
                        mask = line.substring(separator + 1);
                    } else {
                        address = line;
                        mask = "255.255.255.255";
                    }
                    SubnetUtils subnetUtils = null;
                    try {
                        subnetUtils = mask.contains(".") ? new SubnetUtils(address, mask) : new SubnetUtils(String.valueOf(address) + "/" + mask);
                        accessList.add(subnetUtils);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println("**** WARNING: could not process access list information: " + line);
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not read file access.list", ioe);
            }
        }
        return accessList;
    }
}

